import React from 'react';
import {ControlWithErrors} from '@blocks/morda/components/control/control.jsx';
import {clearPersonalInfoFieldErrors} from '@blocks/morda/personal_info/actions';
import {Input} from '@components/Input';

export class Name extends ControlWithErrors {
    constructor(props) {
        super(props);

        this.displayName = 'name';
        this.errors = {
            firstname: {
                empty: i18n('_AUTH_.firstname_errors_missingvalue'),
                invalid: i18n('_AUTH_.NewRegNotes.noiname')
            },
            lastname: {
                empty: i18n('_AUTH_.lastname_errors_missingvalue'),
                invalid: i18n('_AUTH_.NewRegNotes.nofname')
            }
        };

        this.state = {
            firstname: this.props.firstname || '',
            lastname: this.props.lastname || ''
        };

        this.onChange = this.onChange.bind(this);
    }

    componentDidMount() {
        const popupFirstname = this.refs['popup-firstname'] || null;
        const popupLastname = this.refs['popup-lastname'] || null;

        this.entryFirstname = this.refs.firstname || null;
        this.entryLastname = this.refs.lastname || null;

        if (popupFirstname && this.entryFirstname) {
            popupFirstname.setAnchor(this.entryFirstname.block.domElem);
        }

        if (popupLastname && this.entryLastname) {
            popupLastname.setAnchor(this.entryLastname.block.domElem);
        }
    }

    onChange(event) {
        const {target = {}} = event;
        const {value, name} = target;
        const {isVerifiedAccount} = this.props;

        if (isVerifiedAccount) {
            return;
        }

        this.setState({[name]: value});
        this.props.dispatch(clearPersonalInfoFieldErrors(name));
    }

    getRequestParams() {
        return {
            firstname: this.state.firstname || '',
            lastname: this.state.lastname || '',
            passErrors: true
        };
    }

    getEntryView() {
        const {isVerifiedAccount} = this.props;

        return (
            <div>
                <div className='p-control-entry-cntrl' data-t='personal-info-firstname'>
                    <Input
                        disabled={isVerifiedAccount}
                        id='firstname'
                        name='firstname'
                        ref='firstname'
                        value={this.state.firstname}
                        maxLength={this.props.maxLength}
                        autoComplete='off'
                        placeholder={i18n('Profile.personal.data.firstname')}
                        onChange={this.onChange}
                        size='l'
                    />

                    <span data-t='personal-info-firstname-error'>
                        {super.getErrorView.call(this, {field: 'firstname'})}
                    </span>
                </div>

                <div className='p-control-entry-cntrl p-control-entry-cntrl__lastname' data-t='personal-info-lastname'>
                    <Input
                        id='lastname'
                        name='lastname'
                        ref='lastname'
                        value={this.state.lastname}
                        maxLength={this.props.maxLength}
                        autoComplete='off'
                        disabled={isVerifiedAccount}
                        placeholder={i18n('Profile.personal.data.lastname')}
                        onChange={this.onChange}
                        size='l'
                    />

                    <span data-t='personal-info-lastname-error'>
                        {super.getErrorView.call(this, {field: 'lastname'})}
                    </span>
                </div>
            </div>
        );
    }
}

Name.defaultProps = {
    label: i18n('Profile.personal.data.name'),
    maxLength: 50
};
