import './PageMessage.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {EMAILS_GOAL_PREFIX} from '@blocks/morda/emails/actions';
import metrics from '@blocks/metrics.js';

const PAGE_MESSAGES = {
    'backend.blackbox_failed': i18n('Profile.emails.page.errors.blackbox-failed'),
    'email.already_confirmed': i18n('Profile.emails.page.errors.already-confirmed'),
    'email.incorrect_key': i18n('Profile.emails.page.errors.incorrect-key'),
    'account.not_found': i18n('Profile.emails.page.errors.account-disabled'),
    'account.disabled': i18n('Profile.emails.page.errors.account-disabled'),
    'account.disabled_on_deletion': i18n('Profile.emails.page.errors.account-disabled'),
    'emails.success': i18n('Profile.emails.page.description.confirmed', ''),
    'sessionid.no_uid': i18n('_AUTH_.avatar.error-internal')
};

export class PageMessage extends Component {
    constructor(props) {
        super(props);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleSubmit(e) {
        const retpath = this.props.retpath;

        e.preventDefault();
        if (retpath) {
            location.href = decodeURIComponent(retpath);
        } else {
            location.href = `/profile${location.search}`;
        }
    }

    getMessage() {
        const msg = PAGE_MESSAGES[this.props.message];

        if (msg) {
            return msg;
        }

        return PAGE_MESSAGES['sessionid.no_uid'];
    }

    componentDidMount() {
        if (this.props.message === 'emails.success') {
            metrics.goal(`${EMAILS_GOAL_PREFIX}_email_confirmed_link`);
        } else {
            metrics.goal(`${EMAILS_GOAL_PREFIX}_email_error_link`);
        }
    }

    render() {
        const {type} = this.props;

        return (
            <form className='p-control-form emails-add emails-add_confirmed PageMessage' onSubmit={this.handleSubmit}>
                <div className='emails-add__description'>
                    <div style={{display: 'tableRow'}}>
                        <div className={`emails-icon__${type}`} />
                        <div className='emails-add__description-text'>{this.getMessage()}</div>
                    </div>
                </div>
                <div className='clearfix'>
                    <div className='p-control-saveblock-cell-right p-control-saveblock-button'>
                        <Button
                            type='submit'
                            size='l'
                            view='action'
                            text={i18n('Profile.emails.page.go-to-settings')}
                        />
                    </div>
                </div>
            </form>
        );
    }
}

PageMessage.propTypes = {
    retpath: PropTypes.string,
    text: PropTypes.string,
    type: PropTypes.string,
    message: PropTypes.string
};
