import React, {Component} from 'react';
import PropTypes from 'prop-types';

export class Phone extends Component {
    constructor(props) {
        super(props);
        this.displayName = 'phone';
    }

    render() {
        const {number, isSecondary} = this.props;

        return <div className={`phone-number ${isSecondary ? 'phone-number__secondary' : ''}`}>{number}</div>;
    }
}

Phone.propTypes = {
    isSecondary: PropTypes.bool,
    number: PropTypes.string.isRequired
};
