import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Modal} from '@components/Modal';
import {Button} from '@components/Button';
import {RegPromoContent} from './reg_promo_content';
import {showRegPopup} from '@blocks/common/actions';

export class RegPromo extends Component {
    constructor(props) {
        super(props);

        this.closePopup = this.closePopup.bind(this);
    }

    closePopup() {
        this.props.dispatch(showRegPopup(false));
    }

    render() {
        const {showRegPopup} = this.props.common;

        let url = '/profile/upgrade?origin=passport_profile';

        if (typeof window !== 'undefined') {
            url = `${url}&retpath=${encodeURIComponent(location.href)}`;
        }

        return (
            <Modal visible={showRegPopup} dataT='reg-promo'>
                <div className='reg-promo'>
                    <RegPromoContent />
                    <div className='reg-promo__buttons'>
                        <div className='reg-promo__no-thanks'>
                            <Button view='pseudo' size='l' type='button' onClick={this.closePopup}>
                                {i18n('Profile.regpromo.no-thanks')}
                            </Button>
                        </div>
                        <Button view='action' size='l' type='link' url={url}>
                            {i18n('Profile.regpromo.register.yandexid')}
                        </Button>
                    </div>
                </div>
            </Modal>
        );
    }
}

RegPromo.propTypes = {
    dispatch: PropTypes.func.isRequired,
    common: PropTypes.shape({
        showRegPopup: PropTypes.bool
    })
};
