import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import Link from '@blocks/morda/components/link/link.jsx';
import {isMobile} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {person = {}} = state;

    return {
        isNeoPhonish: person.isNeoPhonish,
        isMobile: isMobile(state)
    };
};

class RegPromoContent extends Component {
    render() {
        const {isNeoPhonish, pageMessage: isPageMessage, isMobile} = this.props;

        let url = '/profile/upgrade?origin=passport_profile';

        if (typeof window !== 'undefined') {
            url = `${url}&retpath=${encodeURIComponent(location.href)}`;
        }

        if (isNeoPhonish) {
            return (
                <div>
                    {!isMobile && <div className='reg-promo__image reg-promo__image_yandexid' />}
                    <div className='reg-promo__title'>{i18n('Profile.regpromo.title.yandexid')}</div>
                    <div className='reg-promo__description'>{i18n('Profile.regpromo.description.yandexid')}</div>
                    {Boolean(isPageMessage) && <Link url={url}>{i18n('Profile.regpromo.register.yandexid')}</Link>}
                </div>
            );
        }

        return (
            <div>
                {!isMobile && <div className='reg-promo__image' />}
                <div className='reg-promo__title'>{i18n('Profile.regpromo.title')}</div>
                <div className='reg-promo__description'>{i18n('Profile.regpromo.description')}</div>
                {Boolean(isPageMessage) && <Link url={url}>{i18n('Profile.regpromo.register')}</Link>}
            </div>
        );
    }
}

const ConnectedRegPromoContent = connect(mapStateToProps)(RegPromoContent);

export {ConnectedRegPromoContent as RegPromoContent};

RegPromoContent.propTypes = {
    isNeoPhonish: PropTypes.bool,
    pageMessage: PropTypes.string,
    isMobile: PropTypes.bool
};
