import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';

class ReturnButton extends Component {
    shouldComponentUpdate() {
        return false;
    }

    render() {
        const {isModal, retpath, isMobile, className = ''} = this.props;

        if (!isModal && retpath && !isMobile) {
            return (
                <div className={`return-to-service ${className}`}>
                    <Button view='pseudo' size='l' type='link' url={retpath}>
                        {i18n('_AUTH_.go_back')}
                    </Button>
                </div>
            );
        }

        return null;
    }
}

ReturnButton.propTypes = {
    isModal: PropTypes.bool,
    className: PropTypes.string,
    isMobile: PropTypes.bool,
    retpath: PropTypes.string
};

export default ReturnButton;
