import React from 'react';
import {ControlWithErrors} from '@blocks/morda/components/control/control.jsx';
import {Spin} from '@components/Spin';
import {Select} from '@components/Select';
import getTimezones from '@blocks/common/actions/getTimezones';

export class Timezone extends ControlWithErrors {
    constructor(props) {
        super(props);

        this.displayName = 'timezone';
        this.errors = {
            [this.displayName]: {
                empty: i18n('Frontend.timezone_errors_empty')
            }
        };

        this.timezones = null;

        this.getSelectView = this.getSelectView.bind(this);
        this.getErrorView = super.getErrorView.bind(this);
        this.changeTimezone = this.changeTimezone.bind(this);

        this.state = {
            timezone: this.props.timezone || ''
        };
    }

    componentDidMount() {
        if (this.props.timezones) {
            return;
        }

        const lang = this.props.settings && this.props.settings.language;

        this.props.dispatch(getTimezones(lang));
    }

    getRequestParams() {
        return {
            timezone: this.state.timezone || '',
            passErrors: true
        };
    }

    changeTimezone(event) {
        this.setState({timezone: event.target.value});
    }

    getOptions = () => {
        const {timezones} = this.props;

        return [
            {
                text: i18n('Profile.personal.data.timezone.empty'),
                val: ''
            }
        ].concat(
            timezones.map((item) => ({
                value: item.val,
                content: item.text
            }))
        );
    };

    getSelectView() {
        const timezone = this.state.timezone || '';

        if (!this.props.timezones) {
            return null;
        }

        return (
            <Select
                value={timezone}
                size='l'
                dataT='timezone'
                name='timezone'
                width='max'
                onChange={this.changeTimezone}
                options={this.getOptions()}
            />
        );
    }

    getEntryView() {
        return (
            <div className='p-control-entry'>
                {this.props.timezones ? (
                    <div className='personal-info-timezone' data-t='personal-info-timezone'>
                        {this.getSelectView()}
                    </div>
                ) : (
                    <Spin size='m' progress={true} />
                )}

                {this.getErrorView()}
            </div>
        );
    }
}

Timezone.defaultProps = {
    label: i18n('Profile.personal.data.timezone')
};
