import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {push} from 'react-router-redux';
import {Link} from '@components/Link';
import {Modal} from '@components/Modal';
import {showRegPopup, setEditMode} from '@blocks/common/actions';
import {CreateAppPasswordBlock} from './create_app_passwords_block.jsx';

export class CreateAppPassword extends Component {
    constructor(props) {
        super(props);

        this.showCreationPopup = this.showCreationPopup.bind(this);
    }

    showCreationPopup() {
        const {settings, dispatch, isSocialchik, retpath} = this.props;
        const isPhone = (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;

        if (isSocialchik) {
            dispatch(showRegPopup(true));
            return;
        }

        if (isPhone) {
            let redirectUrl = '/profile/generate-apppassword';

            if (retpath) {
                redirectUrl += `?retpath=${encodeURIComponent(retpath)}`;
            }

            dispatch(push(redirectUrl));
        } else {
            dispatch(setEditMode('apppwd-create'));
        }
    }

    render() {
        const {settings, dispatch, edit, appPasswords, isAppPasswordsEnabled} = this.props;
        const isPhone = (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;

        return (
            <div className='p-control-link'>
                <span data-t='access-widget:passwords-create'>
                    <Link pseudo={true} onClick={this.showCreationPopup}>
                        {i18n('Profile.access.create-apppwd')}
                    </Link>
                </span>

                {Boolean(!isPhone) && (
                    <Modal visible={edit === 'apppwd-create'} zIndexGroupLevel={-0.5} dataT='create-app-passwords'>
                        {edit === 'apppwd-create' && (
                            <CreateAppPasswordBlock
                                modal={true}
                                edit={edit}
                                isPhone={isPhone}
                                appPasswords={appPasswords}
                                isAppPasswordsEnabled={isAppPasswordsEnabled}
                                dispatch={dispatch}
                                settings={settings}
                            />
                        )}
                    </Modal>
                )}
            </div>
        );
    }
}

CreateAppPassword.propTypes = {
    appPasswords: PropTypes.object.isRequired,
    isAppPasswordsEnabled: PropTypes.bool.isRequired,
    dispatch: PropTypes.func.isRequired,
    isSocialchik: PropTypes.bool.isRequired,
    edit: PropTypes.string,
    retpath: PropTypes.string,
    settings: PropTypes.object.isRequired
};
