import api from '@blocks/api';
import {updateAppPasswordsStatus} from '@blocks/morda/access/actions';
import {saveActionForRepeat} from '@blocks/common/actions';
import {getClientsInfo, updateAppPwdData, setError} from './actions';
import {setAppPasswordsNumber} from '@blocks/morda/app_passwords/actions';

export const clientLocNames = {
    mail: {
        title: i18n('Profile.access.apppwd-mail'),
        protocol: 'IMAP, POP3, SMTP'
    },
    disk: {
        title: i18n('Profile.access.appwd-files'),
        protocol: 'Webdav'
    },
    addrbook: {
        title: i18n('Profile.access.appwd-contacts'),
        protocol: 'CardDav'
    },
    calendar: {
        title: i18n('Profile.access.appwd-calendar'),
        protocol: 'CalDav'
    },
    chat: {
        title: i18n('Profile.access.appwd-chat'),
        protocol: 'XMPP (Jabber)'
    },
    magnitola: {
        title: i18n('Profile.access.appwd-magnitola'),
        protocol: i18n('Profile.access.appwd-magnitola.protocol')
    }
};

export function getClientInfo() {
    return (dispatch, getState) => {
        const clientsList = getState().appPasswords.createAppPassword.configClients;
        const formattedList = [];

        for (const prop in clientsList) {
            if (clientsList[prop] !== 'collector') {
                const propVal = clientsList[prop];
                const item = {
                    id: prop,
                    name: propVal,
                    locName: clientLocNames[propVal].title,
                    protocol: clientLocNames[propVal].protocol
                };

                formattedList.push(item);
            }
        }
        dispatch(getClientsInfo(formattedList));
    };
}

export function createAppPassword() {
    return (dispatch, getState) => {
        const state = getState();
        const createPassword = state.appPasswords.createAppPassword;
        const numOfCreatedAppPasswords = state.appPasswords.tokens.appPasswordsCount;
        const data = {
            appPasswordsStatus: state.access.isAppPasswordsEnabled ? 'enabled' : 'disabled',
            clientId: createPassword && createPassword.clientId,
            deviceName: createPassword && createPassword.deviceName,
            lang: state.settings.language,
            track_id: state.common.track_id,
            csrf_token: state.common.csrf
        };

        dispatch(updateAppPwdData({passwordCreated: 'processing'}));
        dispatch(saveActionForRepeat(createAppPassword, data.deviceName));
        api.request('profile/apppassword/create/', data)
            .done((response) => {
                if (response && response.alias) {
                    dispatch(updateAppPwdData({passwordCreated: response.alias}));
                    dispatch(setAppPasswordsNumber(numOfCreatedAppPasswords + 1));
                    if (data.appPasswordsStatus === 'disabled') {
                        dispatch(updateAppPasswordsStatus(true));
                    }
                }
            })
            .fail((error) => {
                if (error && error.errors[0] === 'token.limit_exceeded') {
                    const errorMessage = i18n('Profile.apppasswords.limit-error');

                    dispatch(setError(errorMessage));
                }
            });
    };
}
