import {combineReducers} from 'redux';
import {GET_APP_PASSWORDS_CLIENTS, UPDATE_APP_PWD_DATA, SET_ERROR_MESSAGE} from './actions';
import tokens from '@blocks/morda/app_passwords/reducers';

function createAppPassword(state = {}, action) {
    switch (action.type) {
        case GET_APP_PASSWORDS_CLIENTS:
            return $.extend({}, state, {
                clients: action.data
            });
        case UPDATE_APP_PWD_DATA:
            return $.extend({}, state, {
                clientId: action.data.clientId,
                clientName: action.data.clientName,
                deviceName: action.data.deviceName,
                passwordCreated: action.data.passwordCreated,
                error: ''
            });
        case SET_ERROR_MESSAGE:
            return $.extend({}, state, {
                error: action.error,
                passwordCreated: ''
            });
        default: {
            return state;
        }
    }
}

const appPasswords = combineReducers({
    createAppPassword,
    tokens
});

export default appPasswords;
