import api from '@blocks/api';

import {getRequests} from './index';
import metrics from '@blocks/metrics';

export const SET_DB_DATA = 'SET_DB_DATA';
export const SET_DB_ITEM = 'SET_DB_ITEM';
export const SET_DB_ERROR = 'SET_DB_ERROR';
export const SET_DB_LOADING = 'SET_DB_LOADING';
export const SET_DB_MESSAGE = 'SET_DB_MESSAGE';

export const SET_PLUS_ENABLED = 'SET_PLUS_ENABLED';
export const SET_PLUS_NEXT_CHARGE_TIME = 'SET_PLUS_NEXT_CHARGE_TIME';

export const setPlusEnabled = (enabled) => ({
    enabled,
    type: SET_PLUS_ENABLED
});

export const setPlusNextChargeTime = (nextChargeTime) => ({
    nextChargeTime,
    type: SET_PLUS_NEXT_CHARGE_TIME
});

export const setError = (key, error) => ({
    key,
    error,
    type: SET_DB_ERROR
});

export const setMessage = (key, message) => ({
    key,
    message,
    type: SET_DB_MESSAGE
});

export const setLoading = (key, loading) => ({
    key,
    loading,
    type: SET_DB_LOADING
});

export const setItem = (key, item) => ({
    key,
    item,
    type: SET_DB_ITEM
});

export const setData = (service, data) => ({
    data,
    service,
    type: SET_DB_DATA
});

export function outOfBox(data) {
    if (Array.isArray && !Array.isArray(data)) {
        return data;
    }

    let newData = [];

    for (let i = 0; i < data.length; i++) {
        if (typeof data[i] !== 'undefined' && data[i].length) {
            newData = newData.concat(data[i]);
        }
    }

    return newData;
}

export function sendMetrics(service) {
    const metricsData = {
        favMarketData: ['Избранное', 'Есть отложенные товары на маркете'],
        videoData: ['Избранное', 'Есть избранные видео'],
        musicData: ['Личный кабинет', 'Есть подписка на музыку'],
        collectionsData: ['Избранное', 'Есть коллекции'],
        afishaData: ['Личный кабинет', 'Есть билеты в афише'],
        marketData: ['Личный кабинет', 'Есть купленные товары']
    };

    if (metricsData.hasOwnProperty(service)) {
        metrics.send(metricsData[service]);
    }
}

export function getData(toLoad = [], getReqs = getRequests) {
    return (dispatch, getState) => {
        const {
            person: {isSocialchik},
            common: {track_id: trackId},
            settings: {language: lang},
            publicId: {id: publicId}
        } = getState();
        const {videoDataCount, services, requests} = getReqs(isSocialchik, {api, trackId, publicId, lang}, toLoad);
        const videoData = [];
        const onFail = (service, data = {}) => {
            ++videoCount; // eslint-disable-line

            return dispatch(
                setData(service, {
                    errors: Array.isArray(data.errors) ? data.errors : ['exception.unhandled']
                })
            );
        };
        const servicesDispatched = {};

        let videoCount = 0;

        for (let i = 0; i < requests.length; i++) {
            const service = services[i];

            if (!servicesDispatched.hasOwnProperty(service)) {
                servicesDispatched[service] = true;

                dispatch(
                    setData(service, {
                        isLoading: true
                    })
                );
            }

            requests[i]
                .done((d) => {
                    // eslint-disable-line no-loop-func
                    let data = d;

                    if (!data) {
                        return onFail(service);
                    }

                    if (service === 'videoData') {
                        videoData[Number(data.page)] = data.items;

                        if (++videoCount < videoDataCount) {
                            return null;
                        }

                        data = {items: outOfBox(videoData)};
                    }

                    delete data.page;

                    if ((service === 'musicData' && data.dateParts) || (data.items && data.items.length)) {
                        sendMetrics(service);
                    }

                    return dispatch(setData(service, data));
                })
                .fail(onFail.bind(null, service));
        }
    };
}
