import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import Loader from '../../components/loader/loader.jsx';
import Scroll from '../../components/scroll/scroll.jsx';
import Animated from '../../components/animated/animated.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import AfishaCard from './card/card.jsx';

import {FAVORITES, MY} from '../../config';

export default class Afisha extends React.Component {
    shouldComponentUpdate({data: {favorites: prevFav, purchases: prevPurch}}) {
        const data = this.props.data;

        return prevFav !== data.favorites || prevPurch !== data.purchases;
    }

    render() {
        const {
            links,
            login,
            isPhone,
            data: {purchases, favorites}
        } = this.props;

        const userLink = `${links.users}/${login}`;
        const actualPurchases = purchases.actual || [];
        const expiredPurchases = purchases.expired || [];
        const has = {
            actualPurchases: actualPurchases.length > 0,
            favorites: (favorites.items || []).length > 0,
            expiredPurchases: expiredPurchases.length > 0
        };

        return (
            <div id='afisha' className='dashboard__section section__last afisha'>
                {/* remove class 'section__last' */}
                <SectionHead url={links.main} title={i18n('common.serviceTitles.afisha')} icon='afisha' />
                <Loader isLoading={purchases.isLoading || favorites.isLoading} />
                {has.favorites && (
                    <Animated>
                        <div data-t='content:favorites'>
                            <div className='dashboard__section-sub'>{i18n('Favorites.afisha.added')}</div>
                            <Scroll
                                isPhone={isPhone}
                                items={favorites.items}
                                Card={AfishaCard(isPhone, links)}
                                link={{
                                    url: userLink,
                                    text: i18n('Favorites.afisha.events.all')
                                }}
                                metrics={[FAVORITES, 'Все события']}
                            />
                        </div>
                    </Animated>
                )}
                {!favorites.isLoading && (
                    <Animated>
                        <div
                            className={classnames('dashboard__fillers', {
                                'dashboard__fillers-only': !has.favorites
                            })}
                        >
                            {!purchases.isLoading && has.favorites && (
                                <div className='dashboard__filler' data-t='filler:purchased'>
                                    <Subscription
                                        key='1'
                                        url={userLink}
                                        metrics={[MY, 'Нажатие на Моя Афиша']}
                                        title={i18n('Dashboard.afisha.started.title')}
                                    >
                                        {i18n('Dashboard.afisha.common.description')}
                                    </Subscription>
                                </div>
                            )}
                            {!favorites.isLoading && (favorites.hasOwnProperty('errors') || !has.favorites) && (
                                <>
                                    <div className='dashboard__filler' data-t='filler:favorites'>
                                        <Subscription
                                            url={links.main}
                                            title={i18n('Favorites.afisha.start.title')}
                                            metrics={[FAVORITES, 'Нажатие на Найти развлечение']}
                                        >
                                            <div>
                                                <div data-t='afisha:start-desc1'>
                                                    {i18n('Dashboard.afisha.start.desc')}
                                                </div>
                                            </div>
                                        </Subscription>
                                    </div>
                                    <div className='dashboard__filler dashboard__secondary' data-t='filler:favorites'>
                                        <Subscription
                                            key='1'
                                            url={userLink}
                                            metrics={[MY, 'Нажатие на Моя Афиша']}
                                            title={i18n('Dashboard.afisha.started.title')}
                                        >
                                            {i18n('Dashboard.afisha.common.description')}
                                        </Subscription>
                                    </div>
                                </>
                            )}
                        </div>
                    </Animated>
                )}
            </div>
        );
    }
}

Afisha.propTypes = {
    links: PropTypes.object.isRequired,
    login: PropTypes.string.isRequired,
    isPhone: PropTypes.bool.isRequired,
    data: PropTypes.shape({
        favorites: PropTypes.object.isRequired,
        purchases: PropTypes.shape({
            actual: PropTypes.array,
            expired: PropTypes.array,
            isLoading: PropTypes.bool
        })
    }).isRequired
};

Afisha.defaultProps = {
    isFavorites: false
};
