import React from 'react';
import PropTypes from 'prop-types';

import Loader from '../../components/loader/loader.jsx';
import Progress from '../../components/progress/progress.jsx';
import Animated from '../../components/animated/animated.jsx';
import SmallCard from '../../components/small_card/small_card.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import {MY} from '../../config';

export default class Cloud extends React.Component {
    shouldComponentUpdate(nextProps) {
        return this.props.data !== nextProps.data;
    }

    render() {
        const {data, items, links} = this.props;
        const DELIMITER = 1024 * 1024 * 1024;
        const backgrounds = ['light', 'soft', 'solid'];
        const {usedSpace = 0, totalSpace = 0} = data;

        let lowSpace = false;

        let freeSpace = (totalSpace - usedSpace) / DELIMITER;

        if (freeSpace < 1) {
            freeSpace = Math.round(Math.abs(freeSpace) * 1024);
            lowSpace = true;
        }
        if (!data.isLoading) {
            data.error = {};
        }

        return (
            <div id='cloud' className='dashboard__section cloud'>
                <SectionHead url={links.main} title={i18n('common.serviceTitles.cloud')} icon='cloud' />
                <Loader isLoading={data.isLoading} />
                {!data.isLoading && (
                    <Animated>
                        {data.hasOwnProperty('errors') && (
                            <div data-t='d:filler'>
                                {(data.errors || [])[0] === 'disk.not_found' ? (
                                    <Subscription
                                        key='1'
                                        url={links.main}
                                        title={i18n('Dashboard.disk.start.title')}
                                        metrics={[MY, 'Нажатие на Начать пользоваться']}
                                    >
                                        {i18n('Dashboard.disk.start.desc')}
                                    </Subscription>
                                ) : (
                                    <Subscription
                                        key='2'
                                        url={links.feed}
                                        title={i18n('Dashboard.disk.started.title')}
                                        metrics={[MY, 'Нажатие на Открыть историю Диска']}
                                    >
                                        {i18n('Dashboard.disk.started.desc')}
                                    </Subscription>
                                )}
                            </div>
                        )}
                        {!data.hasOwnProperty('errors') && (
                            <div data-t='d:content'>
                                <div className='shared__progress cloud__progress'>
                                    <div className='annotation'>
                                        <span data-t='cloud:used-space'>
                                            {i18n('Dashboard.disk.space.used')}{' '}
                                            {(usedSpace / DELIMITER)
                                                .toFixed(1)
                                                .replace('.', ',')
                                                .replace(',0', '')}{' '}
                                            {i18n('Dashboard.disk.space.gb')}
                                        </span>
                                        {' · '}
                                        <span data-t='cloud:free-space' className={lowSpace ? 'color_red' : ''}>
                                            {i18n('Dashboard.disk.space.free')}{' '}
                                            {freeSpace
                                                .toFixed(1)
                                                .replace('.', ',')
                                                .replace(',0', '')}{' '}
                                            {lowSpace
                                                ? i18n('Dashboard.disk.space.mb')
                                                : i18n('Dashboard.disk.space.gb')}
                                        </span>
                                        <span className='annotation-right'>
                                            {Math.round(totalSpace / DELIMITER)} {i18n('Dashboard.disk.space.gb')}
                                        </span>
                                    </div>
                                    <div className='cloud__progress-content'>
                                        <Progress progress={(usedSpace / totalSpace) * 100} theme='blue' />
                                    </div>
                                </div>
                                <div className='shared__cards cloud__cards'>
                                    <div className='cloud__cards-content cloud__cards-content_padding_top'>
                                        {items.map((item, ndx) => (
                                            <SmallCard
                                                key={ndx}
                                                theme='blue'
                                                name='cloud'
                                                url={item.url}
                                                background={backgrounds[ndx]}
                                                onMouseDown={item.onMouseDown}
                                            >
                                                <div className='cloud__cards-space'>{item.space}</div>
                                            </SmallCard>
                                        ))}
                                    </div>
                                </div>
                                {usedSpace / 1024 / 1024 < 100 ? (
                                    <Subscription
                                        key='5'
                                        bottom={true}
                                        url={links.main}
                                        title={i18n('Dashboard.disk.start.title')}
                                        metrics={[MY, 'Нажатие на Начать пользоваться']}
                                    >
                                        {i18n('Dashboard.disk.start.desc')}
                                    </Subscription>
                                ) : (
                                    <Subscription
                                        key='6'
                                        bottom={true}
                                        url={links.feed}
                                        title={i18n('Dashboard.disk.started.title')}
                                        metrics={[MY, 'Нажатие на Открыть историю Диска']}
                                    >
                                        {i18n('Dashboard.disk.started.desc')}
                                    </Subscription>
                                )}
                            </div>
                        )}
                    </Animated>
                )}
            </div>
        );
    }
}

Cloud.propTypes = {
    items: PropTypes.array.isRequired,
    data: PropTypes.object.isRequired,
    links: PropTypes.object.isRequired
};
