import React from 'react';
import PropTypes from 'prop-types';

import metrics from '@blocks/metrics';
import {FAVORITES} from '../../../config';

const sendMetrics = () => metrics.send([FAVORITES, 'Выбор коллекции']);

export default function CollectionsCard({item}) {
    return (
        <a href={item.link} className='d-card-item d-card-item__link collections-card__item' onMouseDown={sendMetrics}>
            {!item.image ? (
                <div
                    className={`collections-card__image d-card-image d-card-image_empty collections-card__image_${
                        item.slug === 'spisok-zhelanii' ? 'wishlist' : 'empty'
                    }`}
                />
            ) : (
                <div
                    className='collections-card__image d-card-image'
                    style={{
                        backgroundImage: `url("${item.image}")`
                    }}
                />
            )}
            <div className='f-card-content collections-card__content d-card-title'>{item.title}</div>
        </a>
    );
}

CollectionsCard.propTypes = {
    item: PropTypes.shape({
        link: PropTypes.string,
        slug: PropTypes.string,
        image: PropTypes.string,
        title: PropTypes.string.isRequired
    }).isRequired
};
