import React from 'react';
import PropTypes from 'prop-types';

import Scroll from '../../components/scroll/scroll.jsx';
import Loader from '../../components/loader/loader.jsx';
import Animated from '../../components/animated/animated.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import CollectionsCard from './card/card.jsx';

import {FAVORITES} from '../../config';

export default class Collections extends React.Component {
    shouldComponentUpdate(nextProps) {
        return this.props.data !== nextProps.data;
    }

    render() {
        const {data, links, isPhone, publicId} = this.props;
        const items = data.items || [];

        return (
            <div id='collections' className='dashboard__section collections'>
                <SectionHead url={links.main} title={i18n('common.serviceTitles.collections')} icon='collections' />
                <Loader isLoading={data.isLoading} />
                {!data.isLoading && (
                    <Animated>
                        {data.hasOwnProperty('errors') && (
                            <div data-t='d:filler'>
                                <Subscription
                                    url={links.main}
                                    metrics={[FAVORITES, 'Начать собирать']}
                                    title={i18n('Favorites.collections.start.title')}
                                >
                                    {i18n('Favorites.collections.start.desc')}
                                </Subscription>
                            </div>
                        )}
                        {!data.hasOwnProperty('errors') && (
                            <div data-t='d:content'>
                                {items.length ? (
                                    <Scroll
                                        cardCount={4}
                                        items={items}
                                        isPhone={isPhone}
                                        Card={CollectionsCard}
                                        metrics={[FAVORITES, 'Все коллекции']}
                                        link={{
                                            url: links.favorites(publicId),
                                            text: i18n('Favorites.collections.all')
                                        }}
                                    />
                                ) : (
                                    <Subscription
                                        url={links.main}
                                        metrics={[FAVORITES, 'Начать собирать']}
                                        title={i18n('Favorites.collections.start.title')}
                                    >
                                        {i18n('Favorites.collections.start.desc')}
                                    </Subscription>
                                )}
                            </div>
                        )}
                    </Animated>
                )}
            </div>
        );
    }
}

Collections.propTypes = {
    data: PropTypes.object.isRequired,
    links: PropTypes.object.isRequired,
    isPhone: PropTypes.bool.isRequired,
    publicId: PropTypes.string.isRequired
};
