import React from 'react';
import PropTypes from 'prop-types';

const MapsBookmarkCard = (isPhone, links) => {
    const _MapsBookmarkCard = ({item}) => {
        const typeClass = isPhone ? '-touch' : '-desktop';
        const hasCategories = Boolean(item.categories && item.categories.length !== 0);
        const hasRatings = Boolean(item.ratings);
        const hasScore = Boolean(item.score);
        const hasAddress = Boolean(item.address);
        const link = item.coordinates
            ? links.bookmark
                  .replace('%bookmark_id%', item.id)
                  .replace('%bookmark_uri%', item.uri)
                  .replace('%coords%', item.coordinates.join(','))
            : '';
        const registrationStarsClassNamePrefix = 'maps-bookmark-card__rating-star maps-bookmark-card__rating-star-';

        let ratingStars = [];

        if (hasScore) {
            ratingStars = [1, 2, 3, 4, 5].map((starNum) => {
                const scoreDiff = starNum - item.score;

                if (starNum <= item.score || (scoreDiff > 0 && scoreDiff <= 0.2)) {
                    return 'full';
                }

                if (scoreDiff >= 0.4 && scoreDiff <= 0.7) {
                    return 'half';
                }

                return 'empty';
            });
        }

        return (
            <div className='d-card-item'>
                <div
                    className={`maps-bookmark-card__image d-card-image maps-bookmark-card__image${typeClass}`}
                    style={{
                        backgroundImage: `url("${item.photoUrl}")`
                    }}
                />
                <div className={`d-card-content maps-bookmark-card__content${typeClass}`}>
                    <div className='d-card-title maps-bookmark-card__title'>
                        {item.coordinates ? (
                            <a
                                href={link}
                                target='_blank'
                                className='d-link d-link_black'
                                data-t='bookmark-card:bookmark-link'
                                rel='noopener noreferrer'
                            >
                                {item.name}
                            </a>
                        ) : (
                            item.name
                        )}
                    </div>
                    {hasCategories && (
                        <div className='maps-bookmark-card__categories'>{item.categories.join(', ')}</div>
                    )}

                    {hasScore && hasRatings && (
                        <div className='maps-bookmark-card__rating-block'>
                            <span className='maps-bookmark-card__rating-stars'>
                                {ratingStars.map((star, starIndex) => (
                                    <span key={starIndex} className={`${registrationStarsClassNamePrefix}${star}`} />
                                ))}
                            </span>
                            <span className='maps-bookmark-card__score'>
                                <b>{item.score}</b>
                            </span>
                            <span className='maps-bookmark-card__ratings'>({item.ratings})</span>
                        </div>
                    )}

                    {hasAddress && <div className='maps-bookmark-card__address'>{item.address}</div>}
                </div>
            </div>
        );
    };

    _MapsBookmarkCard.propTypes = {
        item: PropTypes.shape({
            name: PropTypes.string.isRequired,
            ratings: PropTypes.array,
            score: PropTypes.number,
            address: PropTypes.string,
            coordinates: PropTypes.array,
            categories: PropTypes.array,
            id: PropTypes.string,
            uri: PropTypes.string,
            photoUrl: PropTypes.string
        }).isRequired
    };

    return _MapsBookmarkCard;
};

export default MapsBookmarkCard;
