import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import Scroll from '../../components/scroll/scroll.jsx';
import Loader from '../../components/loader/loader.jsx';
import Animated from '../../components/animated/animated.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import MapsBookmarkCard from './card/card.jsx';

import {MY} from '../../config';

export default function MapsBookmarks({data, links, isPhone}) {
    const hasItems = (data.items || []).length !== 0;

    return (
        <div id='maps-bookmarks' className='dashboard__section section__last maps-bookmarks'>
            <SectionHead url={links.main} title={i18n('Dashboard.maps.title')} icon='maps' />
            <Loader isLoading={data.isLoading} />
            {hasItems && (
                <Animated>
                    <div data-t='content:favorites'>
                        <div className='dashboard__section-sub'>{i18n('Dashboard.maps.subtitle')}</div>
                        <Scroll
                            isPhone={isPhone}
                            items={data.items}
                            metrics={[MY, 'Все места']}
                            Card={MapsBookmarkCard(isPhone, links)}
                            link={{
                                url: links.bookmarks,
                                text: i18n('Dashboard.maps.bookmarks')
                            }}
                        />
                    </div>
                </Animated>
            )}
            {!data.isLoading && (
                <Animated>
                    <div
                        className={classnames('dashboard__fillers', {
                            'dashboard__fillers-only': !hasItems
                        })}
                    >
                        {(!data.hasOwnProperty('errors') || !hasItems) && (
                            <div className='dashboard__filler' data-t='filler:favorites'>
                                <Subscription
                                    url={links.main}
                                    title={i18n('Dashboard.maps.link')}
                                    metrics={[MY, 'Нажатие на Искать места']}
                                >
                                    <div>
                                        <div data-t='maps:start-desc1'>{i18n('Dashboard.maps.description')}</div>
                                    </div>
                                </Subscription>
                            </div>
                        )}
                    </div>
                </Animated>
            )}
        </div>
    );
}

MapsBookmarks.propTypes = {
    isPhone: PropTypes.bool.isRequired,
    links: PropTypes.object.isRequired,
    data: PropTypes.shape({
        items: PropTypes.array,
        isLoading: PropTypes.bool
    }).isRequired
};
