// @DEPRECATED see https://st.yandex-team.ru/PASSP-25254
// Can be removed

import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

const STATUSES = {
    UNPAID: i18n('Dashboard.market.order.status.unpaid'),
    PICKUP: i18n('Dashboard.market.order.status.pickup'),
    PLACING: i18n('Dashboard.market.order.status.placing'),
    PENDING: i18n('Dashboard.market.order.status.pending'),
    UNKNOWN: i18n('Dashboard.market.order.status.unknown'),
    DELIVERY: i18n('Dashboard.market.order.status.delivery'),
    RESERVED: i18n('Dashboard.market.order.status.reserved'),
    DELIVERED: i18n('Dashboard.market.order.status.delivered'),
    CANCELLED: i18n('Dashboard.market.order.status.cancelled'),
    PROCESSING: i18n('Dashboard.market.order.status.processing')
};
const PAYMENT_METHODS = {
    YANDEX: i18n('Dashboard.market.payment.method.yandex'),
    UNKNOWN: i18n('Dashboard.market.payment.method.unknown'),
    BANK_CARD: i18n('Dashboard.market.payment.method.bank_card'),
    SHOP_PREPAID: i18n('Dashboard.market.payment.method.shop_prepaid'),
    YANDEX_MONEY: i18n('Dashboard.market.payment.method.yandex_money'),
    CASH_ON_DELIVERY: i18n('Dashboard.market.payment.method.cash_on_delivery'),
    CARD_ON_DELIVERY: i18n('Dashboard.market.payment.method.card_on_delivery')
};

export default function MarketCard({item}) {
    const STATUS_DELIVERED = 'DELIVERED';
    const STATUS_CANCELLED = 'CANCELLED';

    return (
        <div className='d-card-item market-card__item'>
            <div className='market-card__content'>
                {item.orderNo && (
                    <div className='market-card__order-no'>
                        {i18n('Dashboard.market_card.order')} №{item.orderNo}
                    </div>
                )}
                <div className='d-card-title market-card__title'>{item.shopName}</div>
                {item.price && (
                    <div className='market-card__price'>
                        {item.price} <span className='rub'>Р</span>
                    </div>
                )}
                <div className='market-card__payment-method'>
                    <span data-t='market-card:pmt' className='font-weight_bold'>
                        {i18n('Dashboard.market_card.payment-method')}:
                    </span>{' '}
                    <span data-t='market-card:pmb'>
                        {PAYMENT_METHODS[item.paymentMethod] || PAYMENT_METHODS.UNKNOWN}
                    </span>
                </div>
                <div className='market-card__status'>
                    <span
                        data-t='market-card:status'
                        className={classnames('font-weight_bold', {
                            'market-card__status_color_green': item.status === STATUS_DELIVERED,
                            'market-card__status_color_red': item.status === STATUS_CANCELLED
                        })}
                    >
                        {STATUSES[item.status] || STATUSES.UNKNOWN}
                    </span>
                    {item.date && (
                        <span>
                            <span className='market-card__status-dot'> · </span>
                            <span data-t='market-card:date'>{item.date}</span>
                        </span>
                    )}
                </div>
            </div>
        </div>
    );
}

MarketCard.propTypes = {
    item: PropTypes.shape({
        date: PropTypes.string,
        status: PropTypes.string,
        price: PropTypes.string.isRequired,
        orderNo: PropTypes.string.isRequired,
        shopName: PropTypes.string.isRequired,
        paymentMethod: PropTypes.string.isRequired
    }).isRequired
};
