import React from 'react';
import PropTypes from 'prop-types';

import metrics from '@blocks/metrics';
import {FAVORITES} from '../../../../config';

const sendMetrics = () => metrics.send([FAVORITES, 'Выбор отложенного товара']);

export default function MarketCardFav({item}) {
    return (
        <a href={item.link} className='d-card-item d-card-item__link f-market-card__item' onMouseDown={sendMetrics}>
            <div className='f-market-card__content'>
                {!item.image ? (
                    <div className='f-market-card__image d-card-image f-market-card__image_empty' />
                ) : (
                    <div
                        className='f-market-card__image d-card-image'
                        style={{
                            backgroundImage: `url("${item.image}")`
                        }}
                    />
                )}
                <div className='d-card-title f-market-card__title'>{item.name}</div>
                <div className='f-market-card__tags'>{item.kind}</div>
                {item.priceMin && (
                    <div className='f-market-card__price-from'>
                        {i18n('Dashboard.from')} {item.priceMin} <span className='rub'>Р</span>
                    </div>
                )}
                {item.priceMax && (
                    <div className='f-market-card__price-to'>
                        {i18n('Dashboard.to')} {item.priceMax} <span className='rub'>Р</span>
                    </div>
                )}
            </div>
        </a>
    );
}

MarketCardFav.propTypes = {
    item: PropTypes.shape({
        priceMin: PropTypes.string,
        priceMax: PropTypes.string,
        link: PropTypes.string.isRequired,
        name: PropTypes.string.isRequired,
        kind: PropTypes.string.isRequired,
        image: PropTypes.string.isRequired
    }).isRequired
};
