import React from 'react';
import PropTypes from 'prop-types';

import Scroll from '../../components/scroll/scroll.jsx';
import Loader from '../../components/loader/loader.jsx';
import Animated from '../../components/animated/animated.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import MarketCardFav from './card/fav/fav.jsx';

import {FAVORITES} from '../../config';

export default class Market extends React.Component {
    shouldComponentUpdate({data: {favorites: prevFav}}) {
        const data = this.props.data;

        return prevFav !== data.favorites;
    }

    render() {
        const {
            links,
            isPhone,
            data: {favorites}
        } = this.props;
        const has = {
            favorites: (favorites.items || []).length > 0
        };

        return (
            <div id='market' className='dashboard__section section__last market'>
                <SectionHead url={links.main} title={i18n('common.serviceTitles.market')} icon='market' />
                <Loader isLoading={favorites.isLoading} />
                {has.favorites && (
                    <React.Fragment>
                        <Animated>
                            <div data-t='content:favorites'>
                                <div className='dashboard__section-sub'>{i18n('Favorites.market.added')}</div>
                                <Scroll
                                    cardCount={4}
                                    isPhone={isPhone}
                                    Card={MarketCardFav}
                                    items={favorites.items}
                                    metrics={[FAVORITES, 'Все товары']}
                                    link={{
                                        url: links.wishlist,
                                        text: i18n('Favorites.market.goods.all')
                                    }}
                                />
                            </div>
                        </Animated>
                        <Animated>
                            <div className='dashboard__fillers'>
                                <div className='dashboard__filler' data-t='filler:favorites'>
                                    <Subscription
                                        key='2'
                                        url={links.main}
                                        metrics={[FAVORITES, 'Нажатие на Найти товар']}
                                        title={i18n('Dashboard.market.start.title')}
                                    >
                                        {i18n('Dashboard.market.start.desc')}
                                    </Subscription>
                                </div>
                            </div>
                        </Animated>
                    </React.Fragment>
                )}
                {!favorites.isLoading && !has.favorites && (
                    <Animated>
                        <div className='dashboard__fillers dashboard__fillers-only'>
                            <div className='dashboard__filler' data-t='filler:favorites'>
                                <Subscription
                                    url={links.main}
                                    metrics={[FAVORITES, 'Начать искать']}
                                    title={i18n('Favorites.market.start.title')}
                                >
                                    {i18n('Favorites.market.start.desc')}
                                </Subscription>
                            </div>
                        </div>
                    </Animated>
                )}
            </div>
        );
    }
}

Market.propTypes = {
    isPhone: PropTypes.bool.isRequired,
    data: PropTypes.shape({
        favorites: PropTypes.object.isRequired
    }).isRequired,
    links: PropTypes.object.isRequired
};
