import React from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';
import metrics from '@blocks/metrics';
import {MY} from '../../config';

let flag = false;

export default function Money({links, yamoney}) {
    const {sum, progress} = yamoney;

    if (sum && !flag) {
        flag = true;

        metrics.send([MY, 'Есть открытый кошелек']);
    }

    return (
        <div id='money' className='dashboard__section money'>
            <SectionHead url={links.main} title={i18n('common.serviceTitles.money')} icon='money' />
            {progress && (
                <div className='money__loader'>
                    <div className='dashboard__loader dashboard__loader_active'>
                        <span className='dashboard__l-text'>{i18n('Dashboard.loading-data')}...</span>
                        <Spin progress={true} size='xxs' />
                    </div>
                </div>
            )}
            {!progress &&
                (sum ? (
                    <div>
                        <div className='money__account-info'>
                            {i18n('Dashboard.money.yr-balance')}: {sum.toString().replace('.', ',')}{' '}
                            <span className='rub'>Р</span>
                        </div>
                        <Subscription
                            key='1'
                            url={links.main}
                            bottom={true}
                            title={i18n('Dashboard.money.started.title')}
                            metrics={[MY, 'Нажатие на Перейти в кошелек']}
                        >
                            {i18n('Dashboard.money.started.desc')}
                        </Subscription>
                    </div>
                ) : (
                    <Subscription
                        key='2'
                        url={links.main}
                        title={i18n('Dashboard.money.wallet.start')}
                        metrics={[MY, 'Нажатие на Открыть кошелек']}
                    >
                        {i18n('Dashboard.money.wallet.desc1')}
                    </Subscription>
                ))}
        </div>
    );
}

Money.propTypes = {
    links: PropTypes.object.isRequired,
    yamoney: PropTypes.shape({
        progress: PropTypes.bool,
        sum: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
    }).isRequired
};
