import React from 'react';
import PropTypes from 'prop-types';

export default function MoneyCardBonus({
    isIE,
    item: {logoSvg, logoPng, expireAt, acceptUrl, conditions, description, color = '#000', backgroundColor = '#fff'}
}) {
    const logo = (isIE ? logoPng : logoSvg) || logoSvg || logoPng;

    return (
        <a href={acceptUrl} className='d-card-item bonus-card__item' style={{backgroundColor, color}}>
            <div className='d-card-content bonus-card__content'>
                <div className='bonus-card__image d-card-image'>
                    <img src={logo} role='presentation' />
                </div>
                <div className='d-card-title bonus-card__title'>{description}</div>
                <div className='bonus-card__date'>
                    {i18n('Dashboard.to')} {expireAt}
                </div>
                <div className='bonus-card__desc'>{conditions}</div>
            </div>
        </a>
    );
}

MoneyCardBonus.propTypes = {
    isIE: PropTypes.bool.isRequired,
    item: PropTypes.shape({
        logoSvg: PropTypes.string,
        logoPng: PropTypes.string,
        description: PropTypes.string.isRequired,
        expireAt: PropTypes.string.isRequired,
        conditions: PropTypes.string.isRequired,
        backgroundColor: PropTypes.string,
        color: PropTypes.string,
        acceptUrl: PropTypes.string
    }).isRequired
};
