import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export default function MoneyCard({item: {icon, date, title, amount, direction}}) {
    const isPositive = direction === 'in';

    return (
        <div className='d-card-item money-card__item'>
            {icon && (
                <div className='money-card__image d-card-image'>
                    <img src={icon} role='presentation' />
                </div>
            )}
            <div className='d-card-content money-card__content'>
                <div className='d-card-title money-card__title'>{title}</div>
                <div className='money-card__date'>{date}</div>
                {amount && (
                    <div
                        className={classnames('money-card__cost', {
                            color_green: isPositive
                        })}
                    >
                        {`${(isPositive ? '+' : '−') + Math.abs(amount)} `}
                        <span className='rub'>Р</span>
                    </div>
                )}
            </div>
        </div>
    );
}

MoneyCard.propTypes = {
    item: PropTypes.shape({
        icon: PropTypes.string,
        currency: PropTypes.string,
        date: PropTypes.string.isRequired,
        title: PropTypes.string.isRequired,
        amount: PropTypes.string.isRequired,
        direction: PropTypes.string.isRequired
    }).isRequired
};
