import React from 'react';
import PropTypes from 'prop-types';

import Scroll from '../../components/scroll/scroll.jsx';
import Loader from '../../components/loader/loader.jsx';
import Animated from '../../components/animated/animated.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import MoneyCard from './card/card.jsx';
import BonusCard from './card/bonus/bonus.jsx';

import {MY} from '../../config';

export default function Money({
    isIE,
    links,
    isPhone,
    data: {errors, isLoading, offers = {}, balance = {}, history = {}}
}) {
    const has = {
        history: (history.items || []).length > 0,
        offers: (offers.items || []).length > 0,
        errors: Boolean(errors)
    };
    const noWallet = (balance.errors || [])[0] === 'money.not_found';
    const bottomStartedSub = ( // eslint-disable-line no-extra-parens
        <Subscription
            key='a'
            bottom={true}
            url={links.main}
            title={i18n('Dashboard.money.started.title')}
            metrics={[MY, 'Нажатие на Перейти в кошелек']}
        >
            {i18n('Dashboard.money.started.desc')}
        </Subscription>
    );
    const bonus = balance.bonus || 0;

    return (
        <div id='money' className='dashboard__section money'>
            <SectionHead url={links.main} title={i18n('common.serviceTitles.money')} icon='money' />
            <Loader isLoading={isLoading} />
            {!isLoading && (
                <Animated>
                    {has.errors && (
                        <div data-t='d:filler'>
                            <Subscription
                                url={links.main}
                                title={i18n('Dashboard.money.wallet.start')}
                                metrics={[MY, 'Нажатие на Открыть кошелек']}
                            >
                                {i18n('Dashboard.money.wallet.desc1')}
                            </Subscription>
                        </div>
                    )}
                    {!has.errors && (
                        <div data-t='d:content'>
                            {noWallet && !has.history && (
                                <Subscription
                                    key='2'
                                    url={links.main}
                                    title={i18n('Dashboard.money.wallet.start')}
                                    metrics={[MY, 'Нажатие на Открыть кошелек']}
                                >
                                    {i18n('Dashboard.money.wallet.desc1')}
                                </Subscription>
                            )}
                            {!balance.errors && (balance.amount !== undefined || balance.bonus !== undefined) && (
                                <div className='money__account-info'>
                                    {balance.amount !== undefined && (
                                        <span>
                                            {balance.amount}
                                            <span className='rub'>Р</span> ·{' '}
                                        </span>
                                    )}
                                    {bonus}{' '}
                                    {i18n({
                                        count: bonus,
                                        one: 'Dashboard.money.points.one',
                                        some: 'Dashboard.money.points.some',
                                        many: 'Dashboard.money.points.many',
                                        none: 'Dashboard.money.points.many'
                                    })}
                                </div>
                            )}
                            {has.history && (
                                <Scroll
                                    cardCount={4}
                                    Card={MoneyCard}
                                    isPhone={isPhone}
                                    items={history.items}
                                    metrics={[MY, 'Все операции']}
                                    link={{
                                        url: links.history,
                                        text: i18n('Dashboard.money.operations.all')
                                    }}
                                />
                            )}
                            {!has.history && !noWallet && bottomStartedSub}
                            {has.offers && (
                                <div>
                                    <div className='money__sub-head'>{i18n('Dashboard.money.bonuses.title')}</div>
                                    <Scroll
                                        cardCount={4}
                                        bottom={true}
                                        Card={BonusCard}
                                        isPhone={isPhone}
                                        cardProps={{isIE}}
                                        items={offers.items}
                                        metrics={[MY, 'Все бонусы']}
                                        link={{
                                            url: links.offers,
                                            text: i18n('Dashboard.money.bonuses.all')
                                        }}
                                    />
                                </div>
                            )}
                            {has.history && bottomStartedSub}
                        </div>
                    )}
                </Animated>
            )}
        </div>
    );
}

Money.propTypes = {
    isIE: PropTypes.bool.isRequired,
    isPhone: PropTypes.bool.isRequired,
    data: PropTypes.object.isRequired,
    links: PropTypes.object.isRequired
};
