import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import Loader from '../../components/loader/loader.jsx';
import Progress from '../../components/progress/progress.jsx';
import Animated from '../../components/animated/animated.jsx';
import SmallCard from '../../components/small_card/small_card.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import {MY} from '../../config';
import metrics from '@blocks/metrics';

const startCommonEvent = () => metrics.send([MY, 'Нажатие на Оформить подписку']);

export default class Music extends React.Component {
    shouldComponentUpdate(nextProps) {
        return this.props.data !== nextProps.data;
    }

    // eslint-disable-next-line complexity
    render() {
        const {data, links} = this.props;
        const {dateParts, canStartTrial, types = {}, vendor, estimated} = data;
        const hasCommon = types.monthly || types.annual;
        const {daysLeft, promoDays} = dateParts || {};

        let annotation = '';

        if (hasCommon) {
            annotation = types.monthly ? i18n('Dashboard.music.type.monthly') : i18n('Dashboard.music.type.annual');

            if (vendor) {
                annotation += ` (${vendor})`;
            }
        }

        if (types.promo || (dateParts && dateParts.promoDays)) {
            annotation += `${hasCommon ? ' + ' : ''}${i18n('Dashboard.music.type.promo')}`;

            if (dateParts && dateParts.promoDays) {
                annotation += ` (${dateParts.promoDays} ${i18n('Dashboard.music.ds')}.)`;
            }
        }

        return (
            <div id='music' className='dashboard__section music'>
                <SectionHead url={links.main} title={i18n('common.serviceTitles.music')} icon='music' />
                <Loader isLoading={data.isLoading} />
                {!data.isLoading && (
                    <Animated>
                        {data.hasOwnProperty('errors') && (
                            <div data-t='d:filler'>
                                <Subscription
                                    url={links.settings}
                                    title={i18n('Dashboard.music.settings.title')}
                                    metrics={[MY, 'Нажатие на Начать слушать Музыку']}
                                >
                                    {i18n('Dashboard.music.settings.desc')}
                                </Subscription>
                            </div>
                        )}
                        {!data.hasOwnProperty('errors') && (
                            <div data-t='d:content'>
                                {dateParts && (
                                    <div className='shared__progress music__progress'>
                                        <div className='annotation'>{annotation}</div>
                                        <div className='music__progress-content'>
                                            <Progress progress={estimated} theme='yellow' />
                                        </div>
                                        <div className='subnotation'>
                                            {dateParts.renewDate &&
                                                `${i18n('Dashboard.music.subscription.renew')} ${dateParts.renewDate}`}
                                            {!dateParts.renewDate && dateParts.daysLeft > 0 && (
                                                <div
                                                    data-t='music:sub-days-left'
                                                    className={dateParts.daysLeft <= 10 ? 'color_red' : ''}
                                                >
                                                    {i18n(
                                                        {
                                                            count: daysLeft,
                                                            one: 'Dashboard.music.subscription-end.one',
                                                            some: 'Dashboard.music.subscription-end.some',
                                                            many: 'Dashboard.music.subscription-end.many',
                                                            none: 'Dashboard.music.subscription-end.many'
                                                        },
                                                        daysLeft
                                                    )}
                                                </div>
                                            )}
                                            {!dateParts.renewDate &&
                                                dateParts.daysLeft === 0 &&
                                                i18n('Dashboard.music.subscription-end.today')}
                                            {promoDays > 0 && (
                                                <div data-t='plus:sub-promo-days-left'>
                                                    {i18n(
                                                        {
                                                            count: promoDays,
                                                            one: 'Dashboard.music.promo_days.one',
                                                            some: 'Dashboard.music.promo_days.some',
                                                            many: 'Dashboard.music.promo_days.many',
                                                            none: 'Dashboard.music.promo_days.many'
                                                        },
                                                        promoDays
                                                    )}
                                                </div>
                                            )}
                                        </div>
                                    </div>
                                )}
                                {!dateParts &&
                                    (canStartTrial ? (
                                        <Subscription
                                            key='19'
                                            left={true}
                                            url={links.main}
                                            title={i18n('Dashboard.music.bonus.offer')}
                                            metrics={[MY, 'Нажатие на Настроить Музыку']}
                                        >
                                            {i18n('Dashboard.music.bonus.condition')}
                                        </Subscription>
                                    ) : (
                                        <Subscription
                                            key='20'
                                            left={true}
                                            url={links.settings}
                                            title={i18n('Dashboard.music.settings.title')}
                                            metrics={[MY, 'Нажатие на Начать слушать Музыку']}
                                        >
                                            {i18n('Dashboard.music.settings.desc')}
                                        </Subscription>
                                    ))}
                                {!hasCommon && (
                                    <div className='shared__cards music__cards'>
                                        <div
                                            className={classnames('music__cards-content', {
                                                'music__card-content_padding_top': typeof dateParts !== 'undefined'
                                            })}
                                        >
                                            <SmallCard
                                                name='music'
                                                theme='yellow'
                                                url={links.startCommon}
                                                onMouseDown={startCommonEvent}
                                                description={i18n('Dashboard.music.pay.desc')}
                                            >
                                                <div>{i18n('Dashboard.music.pay.title')}</div>
                                            </SmallCard>
                                        </div>
                                    </div>
                                )}
                                {dateParts && (
                                    <Subscription
                                        key='21'
                                        url={links.settings}
                                        title={i18n('Dashboard.music.settings.title')}
                                        bottom={!hasCommon}
                                        right={hasCommon}
                                        metrics={[MY, 'Нажатие на Начать слушать Музыку']}
                                    >
                                        {i18n('Dashboard.music.settings.desc')}
                                    </Subscription>
                                )}
                            </div>
                        )}
                    </Animated>
                )}
            </div>
        );
    }
}

Music.propTypes = {
    links: PropTypes.object.isRequired,
    data: PropTypes.shape({
        types: PropTypes.shape({
            promo: PropTypes.bool,
            annual: PropTypes.bool,
            monthly: PropTypes.bool
        }),
        dateParts: PropTypes.shape({
            daysLeft: PropTypes.number,
            renewDate: PropTypes.string,
            promoDays: PropTypes.string
        }),
        vendor: PropTypes.string,
        estimated: PropTypes.number,
        finished: PropTypes.bool,
        canStartTrial: PropTypes.bool,
        isLoading: PropTypes.bool
    }).isRequired
};
