import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Spin} from '@components/Spin';

export default function Button(props) {
    const {onClick, href, theme, disabled, children, className, isLoading} = props;
    const _className = classnames('ps-manage__button', `ps-manage__button_theme_${theme}`, className);

    if (href) {
        return (
            <a href={href} className={_className} onClick={onClick}>
                {children}
            </a>
        );
    }

    return (
        <button
            className={classnames(_className, {
                'ps-manage__button_loading': isLoading
            })}
            disabled={isLoading || disabled}
            onClick={onClick}
        >
            <div className='ps-manage__button-spin'>
                <Spin progress={isLoading} size='xs' />
            </div>
            <div
                className={classnames('ps-manage__button-title', {
                    'ps-manage__button-title_hidden': isLoading
                })}
            >
                {children}
            </div>
        </button>
    );
}

Button.defaultProps = {
    theme: 'yellow'
};

Button.propTypes = {
    onClick: PropTypes.func,
    disabled: PropTypes.bool,
    isLoading: PropTypes.bool,
    href: PropTypes.string,
    className: PropTypes.string,
    theme: PropTypes.oneOf([
        'white',
        'blank',
        'yellow',
        'border',
        'lite-yellow',
        'new-plus_main',
        'new-plus_secondary'
    ]),
    children: PropTypes.oneOfType([PropTypes.string, PropTypes.element, PropTypes.array])
};
