import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {connect} from 'react-redux';

import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import Button from './components/button/button.jsx';

import {MY} from '../../config';

const titles = [i18n('Dashboard.plus.title.station'), i18n('Dashboard.plus.title')];

export class Plus extends React.Component {
    constructor(props) {
        super(props);

        this.isKZorBYTld = ['kz', 'by'].includes(props.tld);
        this.isKZorBYIp = ['kz', 'by'].includes(props.plus.country);
    }

    _maybeRenderFamilyButton = (className) => {
        const {plus, plusHost, flags} = this.props;

        const hasPlusUpgradeExp = flags.includes('plus-redesign-enable');
        const familyURL = plus.familySubType ? '/profile/family' : `${plusHost}/family`;
        const isChild = plus.familySubType === 'CHILD';
        const isFamilyAllowed = !isChild && !this.isKZorBYIp && !this.isKZorBYTld;

        let theme;

        if (hasPlusUpgradeExp) {
            theme = plus.familySubType ? 'new-plus_secondary' : 'new-plus_main';
        } else {
            theme = 'lite-yellow';
        }

        return (
            isFamilyAllowed && (
                <div className={className}>
                    <Button href={familyURL} theme={theme}>
                        {!plus.familySubType
                            ? i18n('Dashboard.subscribe.family')
                            : i18n('Dashboard.subscription.manage.family')}
                    </Button>
                </div>
            )
        );
    };

    render() {
        const {plus, isTouch, innerCN, plusHost, flags, isNewLayout} = this.props;
        const now = Date.now();
        const disabled = !plus.enabled && (!plus.subscriptionExpireTime || plus.subscriptionExpireTime < now);
        const familyURL = `${plusHost}/family`;
        const hasPlusUpgradeExp = flags.includes('plus-redesign-enable');
        const editPlusUrl = `${plusHost}/my?from=passport-services`;

        return (
            <div
                id={hasPlusUpgradeExp ? 'new-plus' : 'plus'}
                className={classnames(
                    'dashboard__section',
                    hasPlusUpgradeExp ? 'new-plus' : 'plus',
                    hasPlusUpgradeExp ? 'new-plus__section' : 'plus__section',
                    isNewLayout && 'plus_rounded'
                )}
            >
                {hasPlusUpgradeExp ? (
                    <div className='plus__outer-bg plus__bg-new' />
                ) : (
                    <div className='plus__outer-bg'>
                        <div className='plus__outer-bg-left' />
                        <div className='plus__outer-bg-right' />
                        <div className='plus__bg-items'>
                            {[0, 1, 2, 3].map((index) => (
                                <div
                                    className={classnames(`plus__bg-item plus__bg-item-n${index}`, {
                                        'plus__bg-item_touch': isTouch
                                    })}
                                    key={index}
                                />
                            ))}
                        </div>
                    </div>
                )}
                <div className='dashboard__wrapper'>
                    <div className={innerCN}>
                        <SectionHead
                            icon={hasPlusUpgradeExp ? 'new-plus' : 'plus'}
                            theme={hasPlusUpgradeExp ? 'black' : 'white'}
                            url={plusHost}
                            titles={titles}
                            activeTitleIndex={1}
                        />
                        {disabled && (
                            <div data-t='d:filler'>
                                <Subscription
                                    theme={hasPlusUpgradeExp ? 'default' : 'white'}
                                    hasOpacity={false}
                                    metrics={[MY, 'Подключить плюс']}
                                    title={
                                        !hasPlusUpgradeExp && (
                                            <div className='plus__family-sub_button'>
                                                <Button theme='lite-yellow' href={`${plusHost}/getplus`}>
                                                    {i18n('Dashboard.plus.subscribe')}
                                                </Button>
                                            </div>
                                        )
                                    }
                                >
                                    {hasPlusUpgradeExp && (
                                        <div className='plus__family-sub_button new-plus'>
                                            <Button
                                                href={`${plusHost}/getplus`}
                                                theme={'new-plus_main'}
                                                className='plus__full_width'
                                            >
                                                {i18n('Dashboard.plus.subscribe')}
                                            </Button>
                                        </div>
                                    )}

                                    {!this.isKZorBYIp && !this.isKZorBYTld && (
                                        <div
                                            className={classnames('plus__family-sub_button', {
                                                'new-plus': hasPlusUpgradeExp
                                            })}
                                        >
                                            <Button
                                                href={familyURL}
                                                theme={hasPlusUpgradeExp ? 'new-plus_secondary' : 'white'}
                                                className={hasPlusUpgradeExp ? 'plus__full_width' : null}
                                            >
                                                {i18n('Dashboard.family_subscription.activate')}
                                            </Button>
                                        </div>
                                    )}
                                    <div className={classnames('plus__family-sub', {'new-plus': hasPlusUpgradeExp})}>
                                        {hasPlusUpgradeExp
                                            ? i18n('Dashboard.plus.subscription.info.new.plus')
                                            : i18n('Dashboard.plus.subscription.info')}
                                    </div>
                                </Subscription>
                            </div>
                        )}
                        {!disabled && (
                            <div data-t='d:content'>
                                <div
                                    className={classnames('plus__info', {'new-plus': hasPlusUpgradeExp})}
                                    dangerouslySetInnerHTML={{
                                        __html: i18n('Subscriptions.go_to_subscriptions_from_plus').replace(
                                            '%PLUS_URL%',
                                            editPlusUrl
                                        )
                                    }}
                                />
                                {this._maybeRenderFamilyButton('plus__family-manage')}
                            </div>
                        )}
                    </div>
                </div>
            </div>
        );
    }
}

Plus.propTypes = {
    isNewLayout: PropTypes.bool,
    isInfoHidden: PropTypes.bool,
    isTouch: PropTypes.bool.isRequired,
    innerCN: PropTypes.string.isRequired,
    tld: PropTypes.string.isRequired,
    plusHost: PropTypes.string.isRequired,
    flags: PropTypes.arrayOf(PropTypes.string).isRequired,
    plus: PropTypes.object.isRequired
};

export default connect(
    ({
        dashboard: {
            plus,
            items: {isInfoHidden}
        },
        common: {experiments: {flags = []} = {}} = {},
        settings: {isTouch, tld, plusHost, isNewLayout}
    }) => ({
        plus,
        isTouch,
        tld,
        plusHost,
        isNewLayout,
        isInfoHidden,
        flags
    })
)(Plus);
