import React from 'react';
import PropTypes from 'prop-types';

import metrics from '@blocks/metrics';
import {FAVORITES} from '../../../config';

const sendMetrics = () => metrics.send([FAVORITES, 'Выбор ролика']);

export default function VideoCard({item}) {
    return (
        <a href={item.yurl} className='d-card-item d-card-item__link video-card__item' onMouseDown={sendMetrics}>
            <div
                className='video-card__image d-card-image'
                style={{
                    backgroundImage: item.thumbnail && `url("${item.thumbnail}")`
                }}
            >
                <div className='video-card__player-info'>
                    <div>►</div>
                    {(item.formatted && <div>{item.formatted}</div>) || ''}
                    {(item.hd && <div>HD</div>) || ''}
                </div>
            </div>
            <div className='f-card-content video-card__content d-card-title'>{item.title}</div>
        </a>
    );
}

VideoCard.propTypes = {
    item: PropTypes.shape({
        hd: PropTypes.bool,
        url: PropTypes.string,
        yurl: PropTypes.string.isRequired,
        title: PropTypes.string.isRequired,
        thumbnail: PropTypes.string.isRequired,
        formatted: PropTypes.string.isRequired
    }).isRequired
};
