import React from 'react';
import PropTypes from 'prop-types';

import Scroll from '../../components/scroll/scroll.jsx';
import Loader from '../../components/loader/loader.jsx';
import Animated from '../../components/animated/animated.jsx';
import SectionHead from '../../components/section_head/section_head.jsx';
import Subscription from '../../components/subscription/subscription.jsx';

import VideoCard from './card/card.jsx';

import {FAVORITES} from '../../config';

export default class Video extends React.Component {
    shouldComponentUpdate(nextProps) {
        return this.props.data !== nextProps.data;
    }

    render() {
        const {data, links, isPhone} = this.props;
        const items = data.items || [];

        return (
            <div id='video' className='dashboard__section video'>
                <SectionHead url={links.main} title={i18n('common.serviceTitles.video')} icon='video' />
                <Loader isLoading={data.isLoading} />
                {!data.isLoading && (
                    <Animated>
                        {data.hasOwnProperty('errors') && (
                            <div data-t='d:filler'>
                                <Subscription
                                    url={links.main}
                                    metrics={[FAVORITES, 'Найти видеоролик']}
                                    title={i18n('Favorites.video.start.title')}
                                >
                                    {i18n('Favorites.video.start.desc')}
                                </Subscription>
                            </div>
                        )}
                        {!data.hasOwnProperty('errors') && (
                            <div data-t='d:content'>
                                {items.length ? (
                                    <Scroll
                                        cardCount={4}
                                        items={items}
                                        Card={VideoCard}
                                        isPhone={isPhone}
                                        metrics={[FAVORITES, 'Все видео']}
                                        link={{
                                            url: links.favorites,
                                            text: i18n('Favorites.video.all')
                                        }}
                                    />
                                ) : (
                                    <Subscription
                                        url={links.main}
                                        title={i18n('Favorites.video.start.title')}
                                        metrics={[FAVORITES, 'Найти видеоролик']}
                                    >
                                        {i18n('Favorites.video.start.desc')}
                                    </Subscription>
                                )}
                            </div>
                        )}
                    </Animated>
                )}
            </div>
        );
    }
}

Video.propTypes = {
    data: PropTypes.object.isRequired,
    links: PropTypes.object.isRequired,
    isPhone: PropTypes.bool.isRequired
};
