/* eslint-disable no-invalid-this */

export function recomputeHeight() {
    if (typeof this.props.forceHeight !== 'undefined' || this.auto) {
        return;
    }

    if (!this.props.children) {
        if (this.state.contentHeight) {
            this.setState({contentHeight: 0});
        }

        return;
    }

    const content = this.refs.content;
    const contentHeight = content !== undefined && (content.offsetHeight || content.clientHeight);

    if (!contentHeight) {
        if (contentHeight !== 0) {
            this.auto = true;
            this.setState({contentHeight: 'auto'});
        }

        return;
    }

    if (contentHeight === this.lastHeight) {
        return;
    }

    this.lastHeight = contentHeight;
    this.setState({contentHeight});
    clearTimeout(this.timer);
    this.timer = setTimeout(() => {
        this.auto = true;
        this.setState({contentHeight: 'auto'});
    }, 350);
}
