import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import * as extracted from './animated.js';

export default class Animated extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            contentHeight: 0
        };
        this.lastHeight = 0;
    }

    componentDidMount() {
        setTimeout(() => {
            extracted.recomputeHeight.call(this);
        }, 0);
    }

    componentDidUpdate() {
        extracted.recomputeHeight.call(this);
    }

    componentWillUnmount() {
        clearTimeout(this.timer);
    }

    render() {
        const height = this.props.forceHeight || this.state.contentHeight;

        return (
            <div
                className={classnames('d-animated__wrapper', {
                    'd-animated__visible': height
                })}
                style={{height}}
            >
                <div className='d-animated' ref='content'>
                    {this.props.children}
                </div>
            </div>
        );
    }
}

Animated.propTypes = {
    children: PropTypes.oneOfType([PropTypes.element, PropTypes.array]),
    forceHeight: PropTypes.number
};
