import React from 'react';
import PropTypes from 'prop-types';

export default function ArrowLink({href, text, className, onMouseDown}) {
    return (
        <div className={`arrow-link__card ${className}`}>
            <a href={href} className='arrow-link' onMouseDown={onMouseDown}>
                <div className='arrow-link__arrow'>
                    <svg className='passport-Icon-SVG'>
                        <use xlinkHref='#Icon_arrow_right_blue' />
                    </svg>
                </div>
                <div className='arrow-link__text'>{text}</div>
            </a>
        </div>
    );
}

ArrowLink.propTypes = {
    onMouseDown: PropTypes.func.isRequired,
    href: PropTypes.string.isRequired,
    text: PropTypes.string.isRequired,
    className: PropTypes.string.isRequired
};
