import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Button} from '@components/Button';

import * as extracted from './banner.js';

export default class Banner extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            toggler: true
        };
        this.closeBanner = extracted.closeBanner.bind(this);
    }

    render() {
        const showBanner = typeof localStorage !== 'undefined' && localStorage.getItem('banner') === null;

        return (
            <div
                className={classnames('banner', {
                    closed: !showBanner
                })}
            >
                <div className='banner__wrapper'>
                    <div
                        className={classnames('banner__inner', {
                            banner__inner_touch: this.props.isPhone
                        })}
                    >
                        <div className='banner__image'>
                            <svg>
                                <use xlinkHref='#Dashboard_banner' />
                            </svg>
                        </div>
                        <div className='banner__title'>{i18n('Dashboard.banner.title')}</div>
                        <div className='banner__desc'>{i18n('Dashboard.banner.desc')}</div>
                        <div className='banner__button-ok'>
                            <Button size='l' view='pseudo' onClick={this.closeBanner}>
                                {i18n('Dashboard.banner.ok')}
                            </Button>
                        </div>
                        <div className='p-control-close banner__button-close' onClick={this.closeBanner} />
                    </div>
                </div>
            </div>
        );
    }
}

Banner.propTypes = {
    isPhone: PropTypes.bool
};
