import React from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import Animated from '../animated/animated.jsx';
import * as extracted from './loader.js';

export default class Loader extends React.Component {
    componentDidUpdate() {
        extracted.update.call(this);
    }

    componentWillUnmount() {
        clearTimeout(this.timer);
    }

    render() {
        if (this.removed) {
            return null;
        }

        return (
            <Animated forceHeight={this.props.isLoading ? 18 : 0}>
                <div className='dashboard__loader'>
                    <span className='dashboard__l-text'>{i18n('Dashboard.loading-data')}...</span>
                    <Spin progress={true} size='xxs' />
                </div>
            </Animated>
        );
    }
}

Loader.defaultProps = {
    isLoading: false
};

Loader.propTypes = {
    isLoading: PropTypes.bool.isRequired
};
