import React from 'react';
import PropTypes from 'prop-types';

export default class Progress extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            mounted: false
        };
    }

    componentDidMount() {
        setTimeout(() => {
            this.setState({
                mounted: true
            });
        }, 0);
    }

    shouldComponentUpdate(nextProps, nextState) {
        return this.state.mounted !== nextState.mounted;
    }

    render() {
        const {theme, progress, children} = this.props;

        return (
            <div className={`d-progress d-progress__${theme}`}>
                <div
                    className='d-progress__fill'
                    style={{
                        width: this.state.mounted ? `${progress}%` : 0
                    }}
                >
                    {children}
                </div>
            </div>
        );
    }
}

Progress.propTypes = {
    theme: PropTypes.oneOf(['blue', 'yellow', 'plus']).isRequired,
    children: PropTypes.element,
    progress: PropTypes.number.isRequired
};
