import metrics from '@blocks/metrics';

/* eslint-disable no-invalid-this */

export function construct(props) {
    this.sendMetrics = props.metrics && props.metrics.length === 2 && metrics.send.bind(metrics, props.metrics);
}

export function updateScroll() {
    const cardCount = this.cardCount;

    updateCardCount.call(this);
    if (this.cardCount !== cardCount) {
        this.forceUpdate();
    }
}

export function getMax() {
    const {items, link} = this.props;

    return Math.max(0, items.length - this.cardCount + (link ? 1 : 0));
}

export function onScroll(direction) {
    updateCardCount.call(this);
    this.setState((prevState) => {
        const max = getMax.call(this);
        const current = Math.min(max, prevState.scroll);
        const scroll =
            direction === 'left' ? Math.max(0, current - this.cardCount) : Math.min(max, current + this.cardCount);

        return {scroll};
    });
}

export function updateCardCount() {
    const sizes = [600, 840, 930];
    const width = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;

    if (width > sizes.slice(-1)) {
        this.cardCount = this.props.cardCount;
    } else {
        for (let ndx = 0; ndx < sizes.length; ndx++) {
            if (width < sizes[ndx]) {
                this.cardCount = ndx + 1;
                break;
            }
        }
    }
}
