/* eslint-disable no-invalid-this */

const SCROLL_DURATION = 500;

function scrollTo(from, to, element, func) {
    const hasRAF = typeof requestAnimationFrame !== 'undefined';
    const diff = to - from;

    let prevTime = Date.now() - 1;

    let currentTime = 0;

    const animateScroll = () => {
        const now = Date.now();

        currentTime += now - prevTime;
        prevTime = now;
        element[func](diff * (-Math.pow(2, (-10 * currentTime) / SCROLL_DURATION) + 1) + from);
        if (currentTime < SCROLL_DURATION) {
            (hasRAF ? requestAnimationFrame : setTimeout)(animateScroll, hasRAF ? undefined : 20);
        }
    };

    animateScroll();
}

function scrollToActiveService(service) {
    if (!this.props.forceListen && !this.props.isMobile) {
        return;
    }

    const MARGIN = 10;
    const element = $('.sts__inner');
    const scrollLeft = element.scrollLeft();
    const active = $('.sts__service').eq(this.props.services.indexOf(service));
    const offset = active.offset();

    let to = -1;

    if (offset.left < 0) {
        to = scrollLeft + offset.left - MARGIN;
    } else {
        const outerWidth = element.outerWidth();
        const offsetRight = offset.left + active.outerWidth() + MARGIN;

        if (offsetRight > outerWidth) {
            to = scrollLeft - outerWidth + offsetRight;
        }
    }

    if (to === -1) {
        return;
    }

    scrollTo(scrollLeft, to, element, 'scrollLeft');
}

export function scrollToService(service) {
    this.freeze = true;
    setTimeout(() => {
        this.freeze = false;
    }, SCROLL_DURATION + 50);
    this.setState({
        active: service
    });
    scrollTo($(window).scrollTop(), $(`.${this.props.prefix}${service}`).offset().top - 50, $(window), 'scrollTop');
    scrollToActiveService.call(this, service);
}

export function constructHandlers(services) {
    services.forEach((service) => {
        if (!this.handlers.hasOwnProperty(service)) {
            this.handlers[service] = scrollToService.bind(this, service);
        }
    });
}

export function scrollToActivatedService() {
    if (!this.props.activated || this.activatedDone) {
        return;
    }

    const animationTimeoutOfPlus = 300;
    const additionalDelay = 300;

    setTimeout(() => {
        this.activatedDone = true;

        this.setState({
            active: this.props.activated
        });

        scrollToService.call(this, this.props.activated);
    }, animationTimeoutOfPlus + additionalDelay);
}

export function handleScroll() {
    if (this.freeze) {
        return;
    }

    const services = this.props.services;
    const sections = $(`.${this.props.sectionClassName}`);
    const nextState = {
        active: ''
    };

    for (let i = 1; i < sections.length; i++) {
        if (sections.get(i).getBoundingClientRect().top > 200) {
            nextState.active = services[i - 1];
            break;
        }
    }

    if (!nextState.active) {
        nextState.active = services[services.length - 1];
    }

    if (nextState.active !== this.state.active) {
        this.setState(nextState);
        scrollToActiveService.call(this, nextState.active);
    }
}
