import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export default function SectionHead({title, titles, icon, url, theme, activeTitleIndex}) {
    const isFloating = Array.isArray(titles) && titles.length > 0;
    const _titles = isFloating ? titles : [title];

    return (
        <div className='dashboard__section-head'>
            <a href={url} className={`dashboard__icon d-icon-${icon}`} />
            {_titles.map((_title, index) => (
                <div
                    className={classnames('dashboard__section-title', {
                        'dashboard__section-title_active': index === activeTitleIndex,
                        'dashboard__section-title_floating': isFloating
                    })}
                    key={_title}
                >
                    <a href={url} className={`d-link d-link_${theme}`}>
                        {_title}
                    </a>
                </div>
            ))}
            {isFloating && (
                <div className='dashboard__section-title dashboard__v-hidden'>{_titles[activeTitleIndex]}</div>
            )}
        </div>
    );
}

SectionHead.defaultProps = {
    theme: 'black',
    activeTitleIndex: 0
};

SectionHead.propTypes = {
    theme: PropTypes.oneOf(['black', 'white']),
    title: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
    titles: PropTypes.arrayOf(PropTypes.string),
    activeTitleIndex: PropTypes.number,
    url: PropTypes.string.isRequired,
    icon: PropTypes.string.isRequired
};
