import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export default class SmallCard extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            mounted: false
        };
    }

    componentDidMount() {
        setTimeout(() => {
            this.setState({
                mounted: true
            });
        }, 0);
    }

    shouldComponentUpdate(nextProps, nextState) {
        return this.state.mounted !== nextState.mounted;
    }

    render() {
        const {background, theme, children, description, name, onMouseDown, isPlashka, url} = this.props;

        return (
            <a
                href={url}
                className={classnames(`small-card ${name}__small-card small-card__${background}-${theme}`, {
                    cloud__plashka: isPlashka,
                    'small-card_faded': this.state.mounted
                })}
                onMouseDown={onMouseDown}
            >
                <div className='small-card__title'>{children}</div>
                <div className={`small-card__desc ${name}__small-card__desc`}>{description}</div>
            </a>
        );
    }
}

SmallCard.propTypes = {
    onMouseDown: PropTypes.func,
    isPlashka: PropTypes.bool,
    url: PropTypes.string.isRequired,
    name: PropTypes.string.isRequired,
    children: PropTypes.oneOfType([PropTypes.element, PropTypes.string]).isRequired,
    theme: PropTypes.oneOf(['yellow', 'blue']).isRequired,
    description: PropTypes.oneOfType([PropTypes.string, PropTypes.element]).isRequired,
    background: PropTypes.oneOf(['light', 'soft', 'solid'])
};

SmallCard.defaultProps = {
    background: 'solid'
};
