import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import metrika from '@blocks/metrics';

export default class Subscription extends React.Component {
    shouldComponentUpdate() {
        return false;
    }

    render() {
        const {url, bottom, right, left, title, children, hasOpacity, metrics, theme} = this.props;
        const onMouseDown = metrics && metrics.length === 2 && (() => metrika.send(metrics));

        return (
            <div
                className={classnames(`subscription subscription_${theme}`, {
                    subscription_left: left,
                    subscription_right: right,
                    subscription_bottom: bottom,
                    subscription_opacity: hasOpacity
                })}
            >
                {url ? (
                    <a
                        className={classnames('subscription__title', {
                            'd-link': theme !== 'white'
                        })}
                        href={url}
                        onMouseDown={onMouseDown}
                    >
                        {title}
                    </a>
                ) : (
                    <span onMouseDown={onMouseDown}>{title}</span>
                )}
                <div className='subscription__desc'>{children}</div>
            </div>
        );
    }
}

Subscription.defaultProps = {
    hasOpacity: true
};

Subscription.propTypes = {
    title: PropTypes.any.isRequired,
    url: PropTypes.string,
    metrics: PropTypes.arrayOf(PropTypes.string).isRequired,
    left: PropTypes.bool,
    right: PropTypes.bool,
    bottom: PropTypes.bool,
    hasOpacity: PropTypes.bool,
    theme: PropTypes.oneOf(['white', 'default']),
    children: PropTypes.oneOfType([PropTypes.string, PropTypes.element, PropTypes.node]).isRequired
};

Subscription.defaultProps = {
    left: false,
    right: false,
    bottom: false
};
