/* eslint-disable no-param-reassign */

export const FAVORITES = 'Избранное';
export const MY = 'Личный кабинет';

export default (tld) => ({
    disk: {
        main: `https://disk.yandex.${tld}`,
        feed: `https://disk.yandex.${tld}/client/feed`,
        pay: [
            `https://disk.yandex.${tld}/payment/10gb_1m`,
            `https://disk.yandex.${tld}/payment/100gb_1m`,
            `https://disk.yandex.${tld}/payment/1tb_1m`
        ]
    },
    music: {
        main: `https://music.yandex.${tld}`,
        startTrial: `https://music.yandex.${tld}/apps`,
        startCommon: `https://music.yandex.${tld}/pay`,
        settings: `https://music.yandex.${tld}/settings/account`
    },
    money: {
        main: `https://money.yandex.${tld}`
    },
    afisha: {
        main: `https://afisha.yandex.${tld}`,
        users: `https://afisha.yandex.${tld}/users`,
        favorites: (user) => `https://afisha.yandex.${tld}/users/${user}`
    },
    market: {
        main: `https://market.yandex.${tld}`,
        settings: `https://market.yandex.${tld}/my/settings`,
        orders: `https://market.yandex.${tld}/my/orders`,
        wishlist: `https://market.yandex.${tld}/my/wishlist`
    },
    video: {
        main: `https://yandex.${tld}/video`,
        favorites: `https://yandex.${tld}/video/favorites`
    },
    collections: {
        main: `https://yandex.${tld}/collections`,
        favorites: (user) => `https://yandex.${tld}/collections/user/${user}`
    },
    images: {
        main: `https://yandex.${tld}/images`
    },
    maps: {
        main: `https://yandex.${tld}/maps`,
        bookmarks: `https://yandex.${tld}/maps/?mode=bookmarks&bookmarks=true`,
        // eslint-disable-next-line max-len
        bookmark: `https://yandex.${tld}/maps/?mode=bookmarks&bookmarks[id]=%bookmark_id%&bookmarks[uri]=%bookmark_uri%&&ll=%coords%&z=16`
    }
});
