import {getData} from './actions';

/* eslint-disable no-invalid-this */

export function getDataHandler() {
    const {
        person: {isSocialchik},
        dashboard
    } = this.props;
    const services = ['afishaData', 'favMarketData', 'collectionsData', 'favAfishaData', 'mapsBookmarksData'];
    const plus = dashboard.plus;
    const toLoad = [];

    if (!isSocialchik || plus.allowed) {
        services.push('diskData');
    }

    if (isMusicVisible(this.props)) {
        services.push('musicData');
    }

    for (let i = 0; i < services.length; i++) {
        if (
            dashboard.hasOwnProperty(services[i]) &&
            (dashboard[services[i]].initialLoad || dashboard[services[i]].hasOwnProperty('errors'))
        ) {
            toLoad.push(services[i]);
        }
    }

    if (toLoad.length) {
        this.props.dispatch(getData(toLoad));
    }
}

export function isMusicVisible(props) {
    const {
        common,
        settings: {tld},
        dashboard: {plus, musicData}
    } = props;
    const types = musicData.types || {};
    const hasMusic = types.promo || types.monthly || types.annual;
    const musicAllowed = ['ua'].includes(tld);
    const canShowMusic = !common.isPDD && ((!plus.allowed && !plus.enabled) || (hasMusic && !plus.enabled));

    return musicAllowed && canShowMusic;
}

export function isPhone(noTablet = true) {
    const {settings} = this.props;

    if (!noTablet) {
        return settings.ua.isMobile || settings.ua.isTouch;
    }

    return (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;
}

export function pickActivatedService(services) {
    if (typeof location === 'undefined' || !location.hash) {
        return null;
    }

    const hashService = location.hash.slice(1);

    return services.includes(hashService) ? hashService : null;
}
