/* global module */

const getRequests = (isSocialchik, {trackId, api, publicId, lang}, toLoad = []) => {
    const pageSize = 11;
    const videoDataCount = 5;
    const services = toLoad.slice();
    const requests = [];

    let videoPage = 0;

    if (toLoad.indexOf('videoData') !== -1) {
        for (let i = 1; i < videoDataCount; i++) {
            services.push('videoData');
        }
    }

    for (let i = 0; i < services.length; i++) {
        const service = services[i];

        const data = {track_id: trackId, service, pageSize, page: 1, lang};

        if (service === 'videoData') {
            data.pageSize = 4;
            data.page = ++videoPage;
        }

        if (service === 'collectionsData') {
            data.publicId = publicId;
        }

        requests.push(api.request('get-dashboard-external-data', data));
    }

    return {videoDataCount, services, requests};
};

module.exports = {
    getRequests
};
