import {
    SET_DB_DATA,
    SET_DB_ITEM,
    SET_DB_ERROR,
    SET_DB_MESSAGE,
    SET_DB_LOADING,
    SET_PLUS_ENABLED,
    SET_PLUS_NEXT_CHARGE_TIME
} from './actions';

const reducers = {};
const month = 30 * 24 * 60 * 60 * 1000;

reducers[SET_PLUS_NEXT_CHARGE_TIME] = ({plus}, {nextChargeTime}) => ({
    plus: Object.assign({}, plus, {nextChargeTime})
});

reducers[SET_PLUS_ENABLED] = ({plus}, {enabled}) => ({
    plus: Object.assign({}, plus, {
        enabled,
        nextChargeTime: enabled ? Date.now() + month : 0
    })
});

reducers[SET_DB_DATA] = (state, {data, service}) => ({
    [service]: data
});

reducers[SET_DB_ITEM] = ({items}, {key, item}) => ({
    items: Object.assign({}, items, {
        [key]: item
    })
});

reducers[SET_DB_ERROR] = ({errors}, {key, error}) => ({
    errors: Object.assign({}, errors, {
        [key]: error
    })
});

reducers[SET_DB_MESSAGE] = ({messages}, {key, message}) => ({
    messages: Object.assign({}, messages, {
        [key]: message
    })
});

reducers[SET_DB_LOADING] = ({isLoading}, {key, loading}) => ({
    isLoading: Object.assign({}, isLoading, {
        [key]: loading
    })
});

export default function(state = {}, action) {
    if (reducers.hasOwnProperty(action.type)) {
        return Object.assign({}, state, reducers[action.type](state, action));
    }

    return state;
}
