import api from '../../api';
import {showRequestPassword} from '@blocks/morda/components/domik/actions';
import {saveActionForRepeat, showRegPopup} from '../../common/actions';
import {getDevicesTokens, showDisablingTokens, showDevicesWithSameName, updateDevicesListToDisable} from './actions';

export function getDevicesList() {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            lang: state.settings.language,
            csrf_token: state.common.csrf
        };

        api.request('get.grouped.tokens', data).then((response) => {
            dispatch(getDevicesTokens(response));
        });
    };
}

export function revokeDeviceToken(id, tokenType) {
    return (dispatch, getState) => {
        const state = getState();
        const tokensList = state.devices.tokens;
        const sameNameDevices = tokensList.deviceTokens.filter((el) => el.deviceName === state.devices.deviceName);
        const data = {
            lang: state.settings.language,
            tokenId: id,
            csrf_token: state.common.csrf
        };

        dispatch(saveActionForRepeat(revokeDeviceToken, id));
        api.request('apppasswords.token-revoke', data).then((response) => {
            if (response && response.status === 'ok') {
                if (tokenType === 'deviceTokens') {
                    tokensList.deviceTokens = tokensList[tokenType].map(function(item) {
                        const index = item.tokens.findIndex((token) => token.tokenId === parseInt(id, 10));

                        if (index !== -1) {
                            item.tokens.splice(index, 1);
                        }
                        return item;
                    });

                    if (sameNameDevices) {
                        if (sameNameDevices.length === 2) {
                            const deviceIndex = tokensList.deviceTokens.findIndex(
                                (device) => device.deviceId === sameNameDevices[0].deviceId
                            );

                            delete sameNameDevices[0].hasDubles;
                            tokensList.deviceTokens.splice(deviceIndex, 1, sameNameDevices[0]);
                        }
                    }

                    tokensList.deviceTokens = tokensList.deviceTokens.filter(
                        (el) => el.tokens.length > 0 || el.hasXtoken === true
                    );
                } else {
                    tokensList[tokenType] = tokensList[tokenType]
                        ? tokensList[tokenType].filter((el) => el.tokenId !== parseInt(id, 10))
                        : [];
                }
                dispatch(getDevicesTokens(tokensList));
            }
        });
    };
}

export function disableDeviceById(deviceId, hasPassword) {
    return (dispatch, getState) => {
        const state = getState();
        const tokensList = state.devices.tokens;
        const deviceList = tokensList.deviceTokens;
        const otherTokensToDelete = state.devices.otherTokensToDelete;
        const data = {
            lang: state.settings.language,
            csrf_token: state.common.csrf,
            device_id: deviceId
        };
        const deviceToDelete = deviceList.find((el) => el.deviceId === deviceId);

        dispatch(saveActionForRepeat(disableDeviceById, deviceId));
        api.request('devices.revoke-tokens', data)
            .then((response) => {
                if (response && response.status === 'ok') {
                    if (deviceToDelete.hasDubles && !deviceToDelete.duble) {
                        const index = deviceList.findIndex((el) => el.deviceId === deviceId);

                        if (index !== -1) {
                            if (deviceList[index + 2] && deviceList[index + 2].duble) {
                                deviceList[index + 1].hasDubles = 1;
                            }
                            delete deviceList[index + 1].duble;
                        }
                    }
                    if (deviceToDelete.duble) {
                        const devicesWithSameName = deviceList.filter(
                            (el) =>
                                el.deviceName === deviceToDelete.deviceName && el.deviceId !== deviceToDelete.deviceId
                        );

                        if (devicesWithSameName.length === 1 && devicesWithSameName[0].hasDubles) {
                            delete devicesWithSameName[0].hasDubles;
                        }
                    }

                    tokensList.deviceTokens = deviceList.filter((el) => el.deviceId !== deviceId);
                    dispatch(getDevicesTokens(tokensList));

                    if (otherTokensToDelete && otherTokensToDelete.length > 0) {
                        otherTokensToDelete.forEach(function(item) {
                            dispatch(revokeDeviceToken(item.id, item.type));
                        });
                    }
                    dispatch(showDisablingTokens({deviceId: null, show: false, deviceName: ''}));
                    dispatch(showDevicesWithSameName());
                    dispatch(updateDevicesListToDisable([]));
                }
            })
            .fail((err) => {
                if (Array.isArray(err.errors) && err.errors[0] === 'password.required') {
                    if (hasPassword) {
                        dispatch(showRequestPassword(true));
                    } else {
                        dispatch(showRegPopup(true));
                    }
                }
            });
    };
}

export function disableDevicesGroup(ids, hasPassword) {
    return (dispatch, getState) => {
        const state = getState();
        const tokensList = state.devices.tokens;
        const deviceList = tokensList.deviceTokens;
        const otherTokensToDelete = state.devices.otherTokensToDelete;
        const handles = [];

        ids.forEach(function(id) {
            handles.push(
                new Promise(function(resolve) {
                    resolve(
                        api.request('devices.revoke-tokens', {
                            lang: state.settings.language,
                            csrf_token: state.common.csrf,
                            device_id: id
                        })
                    );
                })
            );
        });
        Promise.all(handles)
            .then(() => {
                ids.forEach(function(id) {
                    const index = deviceList.findIndex((el) => el.deviceId === id);

                    deviceList.splice(index, 1);
                });
                tokensList.deviceTokens = deviceList;
                dispatch(getDevicesTokens(tokensList));

                if (otherTokensToDelete && otherTokensToDelete.length > 0) {
                    otherTokensToDelete.forEach(function(item) {
                        dispatch(revokeDeviceToken(item.id, item.type));
                    });
                }
                dispatch(showDisablingTokens({deviceId: null, show: false, deviceName: ''}));
                dispatch(updateDevicesListToDisable([]));
            })
            .catch((err) => {
                if (Array.isArray(err.errors) && err.errors[0] === 'password.required') {
                    if (hasPassword) {
                        dispatch(showRequestPassword(true));
                    } else {
                        dispatch(showRegPopup(true));
                    }
                }
                dispatch(saveActionForRepeat(disableDevicesGroup, ids));
            });
    };
}

export function findDevicesWithSameName(deviceId) {
    return (dispatch, getState) => {
        const state = getState();
        const deviceList = state.devices.tokens.deviceTokens;
        const mainDevice = deviceList.filter((el) => el.deviceId === deviceId);
        const deviceName = mainDevice[0].deviceName;
        const ids = [];
        const tokensWithSameNames = deviceList.filter((el) => el.duble === deviceName);

        tokensWithSameNames.forEach((item) => ids.push(item.deviceId));
        dispatch(showDevicesWithSameName(ids, deviceName));
    };
}

export function getDeviceGroupIds(deviceId) {
    return (dispatch, getState) => {
        const state = getState();
        const deviceList = state.devices.tokens.deviceTokens;
        const mainDevice = deviceList.filter((el) => el.deviceId === deviceId);
        const deviceName = mainDevice[0].deviceName;
        const ids = [];
        const devicesToDelete = [...mainDevice, ...deviceList.filter((el) => el.duble === deviceName)];

        devicesToDelete.forEach(function(item) {
            ids.push(item.deviceId);
        });

        if (state.devices.tokens.deviceName) {
            dispatch(disableDevicesGroup(ids));
        } else {
            if (ids.length > 0) {
                dispatch(updateDevicesListToDisable(ids));
            }
            dispatch(showDisablingTokens({show: true, deviceId, deviceName}));
        }
    };
}
