import {
    GET_TOKENS_BY_DEVICE,
    UPDATE_DEVICE_TOKEN_TAB,
    SHOW_DISABLING_TOKENS,
    SHOW_SAME_NAME_DEVICES,
    UPDATE_DISABLE_LIST,
    UPDATE_DEVICES_DISABLE_LIST
} from './actions';

const defaultState = {
    tokens: {
        deviceTokens: null,
        otherTokens: null,
        isYandexTokens: null
    },
    showDisablingList: false,
    disableDeviceId: '',
    deviceName: '',
    otherTokensToDelete: [],
    devicesToDelete: []
};

export default function devices(state = defaultState, action) {
    switch (action.type) {
        case GET_TOKENS_BY_DEVICE:
            return Object.assign({}, state, {
                tokens: action.list
            });
        case SHOW_DISABLING_TOKENS:
            return Object.assign({}, state, {
                disableDeviceId: action.info.deviceId,
                showDisablingList: action.info.show,
                deviceName: action.info.deviceName
            });
        case SHOW_SAME_NAME_DEVICES: {
            const allTokensList = Object.assign({}, state.tokens);
            const devicesList = (state.tokens.deviceTokens || []).slice();

            let device = action.deviceName;

            if (action.idList && action.idList.length > 0) {
                action.idList.forEach((id) => {
                    for (let i = 0; i < devicesList.length; i++) {
                        if (devicesList[i].deviceId === id) {
                            if (devicesList[i].showDuble) {
                                devicesList[i].showDuble = 0;
                                device = '';
                            } else {
                                devicesList[i].showDuble = 1;
                            }
                        }
                    }
                });
            } else if (devicesList.length) {
                for (const item of devicesList) {
                    if (item.showDuble !== undefined) {
                        item.showDuble = 0;
                    }
                }
            }
            allTokensList.deviceTokens = devicesList || [];

            return Object.assign({}, state, {
                tokens: allTokensList,
                deviceName: device || ''
            });
        }

        case UPDATE_DISABLE_LIST: {
            let disableList = (state.otherTokensToDelete || []).slice();

            if (action.info === undefined) {
                disableList = [];
            } else {
                const index = disableList.findIndex((item) => item === action.info.id);

                if (action.info.state === 'checked') {
                    disableList.push({id: action.info.id, type: action.info.type});
                } else {
                    disableList.splice(index, 1);
                }
            }
            return Object.assign({}, state, {
                otherTokensToDelete: disableList
            });
        }

        case UPDATE_DEVICES_DISABLE_LIST:
            return Object.assign({}, state, {
                devicesToDelete: action.idList
            });
        case UPDATE_DEVICE_TOKEN_TAB: {
            const tokensList = Object.assign({}, state.tokens);
            const id = parseInt(action.id, 10);

            if (!id) {
                if (tokensList.isYandexTokens.length > 0) {
                    tokensList.isYandexTokens = tokensList.isYandexTokens.map((item) =>
                        Object.assign({}, item, {
                            tabOpened: false
                        })
                    );
                }

                return Object.assign({}, state, {
                    tokens: tokensList
                });
            }

            if (action.tokenType === 'deviceTokens') {
                tokensList.deviceTokens = tokensList[action.tokenType].map((item) => {
                    const index = item.tokens.findIndex((token) => token.tokenId === id);

                    if (index !== -1) {
                        const status = item.tokens[index] && !item.tokens[index].tabOpened;
                        const updatedToken = Object.assign({}, item.tokens[index], {
                            tabOpened: status
                        });

                        item.tokens.splice(index, 1, updatedToken);
                    }
                    return item;
                });
            } else {
                const currentList = tokensList[action.tokenType];
                const index = currentList.findIndex((token) => token.tokenId === id);
                const status = currentList[index] && !currentList[index].tabOpened;
                const updatedItem = Object.assign({}, currentList[index], {
                    tabOpened: status
                });
                const newList = currentList.filter((el) => el.tokenId !== id);

                newList.splice(index, 0, updatedItem);
                tokensList[action.tokenType] = newList;
            }
            return Object.assign({}, state, {
                tokens: tokensList
            });
        }
        default:
            return state;
    }
}
