import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Dialog, Button} from '@yandex-id/components';
import {useMatchMedia} from '@yandex-id/components/utils';

import './Documents-DeleteConfirmation.styl';

export const cnDeleteConfirmation = cn('DeleteConfirmation');

export const DeleteConfirmation = (props) => {
    const {isVisible, onAbort, onConfirm} = props;

    const isMobile = useMatchMedia('(max-width: 768px)');

    return (
        <Dialog
            type='auto'
            modal={{
                classNameContent: cnDeleteConfirmation('', {desktop: true}),
                visible: isVisible,
                zIndexGroupLevel: 20,
                keepMounted: false,
                onClose: onAbort
            }}
            drawer={{
                classNameContent: cnDeleteConfirmation('', {mobile: true}),
                keepMounted: false,
                visible: isVisible,
                scope: 'inplace',
                onClose: onAbort
            }}
        >
            <div className={cnDeleteConfirmation('Header', {isMobile})}>
                <div className={cnDeleteConfirmation('Title')}>{i18n('Profile2.documents.delete.question')}</div>
                <div className={cnDeleteConfirmation('Close', {isMobile})} onClick={onAbort} />
            </div>
            <div className={cnDeleteConfirmation('Content')}>
                <Button
                    className={cnDeleteConfirmation('Confirm')}
                    view='action'
                    pin='circle-circle'
                    size='l'
                    onClick={onConfirm}
                >
                    {i18n('Profile2.documents.delete.yes')}
                </Button>
                <Button
                    className={cnDeleteConfirmation('Abort')}
                    view='default'
                    pin='circle-circle'
                    size='l'
                    onClick={onAbort}
                >
                    {i18n('Profile2.documents.delete.no')}
                </Button>
            </div>
        </Dialog>
    );
};

DeleteConfirmation.propTypes = {
    className: PropTypes.string,
    isVisible: PropTypes.bool.isRequired,
    onConfirm: PropTypes.func.isRequired,
    onAbort: PropTypes.func.isRequired
};
