import React, {useState, useRef, useCallback} from 'react';
import PropTypes from 'prop-types';

import {List} from '@yandex-id/components';

import {Registration} from './Registration/Registration';

import {DocumentsListHeader} from './List/Header/Documents-ListHeader';

import {DocumentsListGroup} from './List/Group/Documents-ListGroup';

import {getListGroupByType} from './Documents.utils';
import {cnDocuments, DOC_GROUPS_TYPE} from './constants';

import './Documents.styl';

export const Documents = (props) => {
    const {userUid, isRegisterRequired, language, isPhone, isYaApp} = props;

    const scopeRef = useRef(null);
    const [isRegistrationVisible, setRegistrationVisible] = useState(isRegisterRequired);

    const closeRegistration = useCallback(() => {
        setRegistrationVisible(false);
    }, []);

    const openRegistration = useCallback(() => {
        setRegistrationVisible(true);
    }, []);

    const listGroups = DOC_GROUPS_TYPE.map((type, index) => {
        const {title, items: listItems} = getListGroupByType(type);

        return (
            <DocumentsListGroup
                key={index}
                userUid={userUid}
                isRegisterRequired={isRegisterRequired}
                openRegisterMenu={openRegistration}
                lang={language}
                groupTitle={title}
                items={listItems}
                type={type}
                scope={scopeRef}
            />
        );
    });

    const ListHeader = <DocumentsListHeader isYaApp={isYaApp} />;

    return (
        <div className={cnDocuments()} ref={scopeRef}>
            <List className={cnDocuments('List')} header={ListHeader} groups={listGroups} />
            {isRegisterRequired && (
                <Registration
                    isPhone={isPhone}
                    isBlockVisible={isRegistrationVisible}
                    scopeRef={scopeRef}
                    onClose={closeRegistration}
                />
            )}
        </div>
    );
};

Documents.propTypes = {
    userUid: PropTypes.number.isRequired,
    isRegisterRequired: PropTypes.bool.isRequired,
    language: PropTypes.string.isRequired,
    isPhone: PropTypes.bool,
    isYaApp: PropTypes.bool
};
