import {docs, docsFolder} from './constants';

export const getFolderDocName = (lang) => {
    switch (lang) {
        case 'ru':
            return docsFolder.ru;
        case 'ua':
            return docsFolder.ua;
        case 'tr':
            return docsFolder.tr;
        default:
            return docsFolder.en;
    }
};

export const getLocalizedDocNameById = (lang) => (id) => {
    const doc = docs[id];

    switch (lang) {
        case 'ru':
            return doc.ru;
        case 'ua':
            return doc.ua;
        case 'tr':
            return doc.tr;
        default:
            return doc.en;
    }
};

export const getDocNamesById = (id) => {
    return docs[id];
};

export const documentMapper = {
    passport: 'national_id',
    inn: 'inn',
    driverLicense: 'driver_license',
    oms: 'medical_insurance',
    snils: 'snils',
    intPassport: 'international_id'
};

export const mainDocumentListItems = [
    {
        id: 'passport'
    },
    {
        id: 'inn'
    },
    {
        id: 'snils'
    },
    {
        id: 'oms'
    },
    {
        id: 'intPassport'
    },
    {
        id: 'driverLicense'
    }
];

export const DocumentsListMainGroup = {
    title: 'Главное',
    items: mainDocumentListItems
};

/**
 * @param {'main'} type - Тип набора документов
 * @default Список основных документов (main)
 * @returns Массив документов в сыром виде.
 */
export const getListGroupByType = (type) => {
    switch (type) {
        case 'main':
            return DocumentsListMainGroup;
        default:
            return DocumentsListMainGroup;
    }
};
