import React from 'react';
import PropTypes from 'prop-types';

import {DrawerPhone as Drawer} from '@yandex-id/components';

import {cnDocuments} from '../constants';

export const DocumentsDrawer = (props) => {
    const {
        children,
        view = 'default',

        ...restProps
    } = props;

    return (
        <Drawer className={cnDocuments('Menu')} view={view} {...restProps}>
            {children}
        </Drawer>
    );
};

DocumentsDrawer.propTypes = {
    view: PropTypes.string,
    children: PropTypes.element,
    scope: PropTypes.object,
    visible: PropTypes.bool,
    onClose: PropTypes.func
};
